/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.renderers.gun;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.geo.render.ItemAnimator;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.handlers.ClientTickHandler;
import com.nukateam.ntgl.client.render.GeoRenderUtils;
import com.nukateam.ntgl.client.render.layers.GlowingLayer;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.util.TransformUtils;
import com.nukateam.ntgl.common.base.holders.AttachmentType;
import com.nukateam.ntgl.common.data.attachment.impl.Barrel;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.foundation.item.attachment.BarrelItem;
import com.nukateam.ntgl.common.util.data.Rgba;
import com.nukateam.ntgl.common.util.helpers.compatibility.ChassisHelper;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.ArrayList;
import java.util.Map;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.util.ClientUtils;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DynamicGunRenderer<Animator extends ItemAnimator>
extends DynamicGeoItemRenderer<Animator> {
    public static final String RIGHT_ARM = "right_arm";
    public static final String LEFT_ARM = "left_arm";
    public static final String MUZZLE_FLASH = "muzzle_flash";
    protected MultiBufferSource bufferSource;
    protected ArrayList<ItemStack> gunAttachments;
    protected ArrayList<Modules.Attachment> configAttachments;
    protected ArrayList<String> hiddenBones = new ArrayList();
    protected BarrelItem barrelItem;
    protected Gun gun;
    protected ItemStack gunStack;
    protected boolean firstRightRender = true;
    protected boolean firstLeftRender = true;
    private ItemDisplayContext transformType;

    public DynamicGunRenderer(GeoModel<Animator> model) {
        super(model);
        this.addRenderLayer(new GlowingLayer(this));
        ClientTickHandler.addTicker((Object)this, this::tick);
    }

    protected void tick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }

    @Override
    public void render(LivingEntity entity, ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, int packedLight) {
        BarrelItem barrel;
        this.bufferSource = bufferSource;
        this.transformType = transformType;
        this.gun = GunModifierHelper.getGun(stack);
        this.gunStack = stack;
        this.gunAttachments = Gun.getAttachmentItems(stack);
        this.configAttachments = this.gun.getAttachments(this.gunAttachments);
        this.firstRightRender = true;
        this.firstLeftRender = true;
        this.currentEntity = entity;
        if (TransformUtils.isFirstPerson(transformType) && AimingHandler.isScoping(stack)) {
            return;
        }
        ItemStack barrelStack = Gun.getAttachmentItem(AttachmentType.BARREL, stack);
        Item item = barrelStack.m_41720_();
        this.barrelItem = item instanceof BarrelItem ? (barrel = (BarrelItem)item) : null;
        this.prepareHiddenBones(transformType);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, -0.375, 0.0);
        super.render(entity, stack, transformType, poseStack, bufferSource, renderType, buffer, packedLight);
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack poseStack, Animator animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.renderAttachments(bone);
        switch (bone.getName()) {
            case "left_arm": 
            case "right_arm": {
                bone.setHidden(true);
                bone.setChildrenHidden(false);
                this.renderArms(poseStack, animatable, bone, renderType, bufferSource, isReRender, partialTick, packedLight, packedOverlay, new Rgba(red, green, blue, alpha));
                break;
            }
            case "muzzle_flash": {
                if (this.barrelItem == null) break;
                this.renderMuzzleFlash(poseStack);
            }
        }
        this.renderRecursivelyPost(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, this.bufferSource.m_6299_(renderType), isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public LivingEntity getRenderEntity() {
        return this.currentEntity;
    }

    protected boolean shouldRenderAttachment(Modules.Attachment attachment, ItemStack item) {
        if (this.transformType != ItemDisplayContext.GUI) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
            return !item.m_41619_() && attachment.getItemId().equals((Object)itemId);
        }
        return false;
    }

    protected void renderAttachments(GeoBone bone) {
        String boneName = bone.getName();
        boolean hideBone = this.hiddenBones.stream().anyMatch(s -> s.equals(boneName));
        bone.setHidden(hideBone);
    }

    protected void renderRecursivelyPost(PoseStack poseStack, Animator animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    protected void renderArms(PoseStack poseStack, Animator animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, boolean isReRender, float partialTick, int packedLight, int packedOverlay, Rgba rgba) {
        boolean isLeftHand;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            return;
        }
        boolean isRightHand = this.transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        boolean bl = isLeftHand = this.transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        if (bone.getName().equals(RIGHT_ARM)) {
            if (!this.firstRightRender) {
                return;
            }
            this.firstRightRender = false;
        }
        if (bone.getName().equals(LEFT_ARM)) {
            if (!this.firstLeftRender) {
                return;
            }
            this.firstLeftRender = false;
        }
        if (isRightHand || isLeftHand) {
            poseStack.m_85836_();
            RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
            poseStack.m_85837_(0.01, -0.27, 0.05);
            poseStack.m_85841_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            if (ChassisHelper.isPlayerInChassis()) {
                if (isRightHand) {
                    if (bone.getName().equals(LEFT_ARM)) {
                        ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.LEFT, packedLight);
                    } else if (bone.getName().equals(RIGHT_ARM)) {
                        ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.RIGHT, packedLight);
                    }
                } else if (bone.getName().equals(LEFT_ARM)) {
                    ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.RIGHT, packedLight);
                } else if (bone.getName().equals(RIGHT_ARM)) {
                    ChassisHelper.renderChassisHand(poseStack, isRightHand, HumanoidArm.LEFT, packedLight);
                }
            } else {
                ResourceLocation playerSkin = ((LocalPlayer)ClientUtils.getClientPlayer()).m_108560_();
                VertexConsumer arm = this.bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)playerSkin));
                VertexConsumer sleeve = this.bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin));
                if (isRightHand) {
                    if (bone.getName().equals(LEFT_ARM)) {
                        GeoRenderUtils.renderLeftArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                    } else if (bone.getName().equals(RIGHT_ARM)) {
                        GeoRenderUtils.renderRightArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                    }
                } else if (bone.getName().equals(LEFT_ARM)) {
                    GeoRenderUtils.renderRightArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                } else if (bone.getName().equals(RIGHT_ARM)) {
                    GeoRenderUtils.renderLeftArm(poseStack, bone, packedLight, packedOverlay, arm, sleeve);
                }
            }
            poseStack.m_85849_();
        }
    }

    protected void renderMuzzleFlash(PoseStack poseStack) {
        float length = ((Barrel)this.barrelItem.getProperties()).getLength();
        poseStack.m_85837_(0.0, 0.0, (double)(-length) / 16.0);
        if (Ntgl.isDebugging()) {
            poseStack.m_85837_((double)(-ClientDebug.X) / 10.0 / 16.0, (double)ClientDebug.Y / 10.0 / 16.0, (double)ClientDebug.Z / 10.0 / 16.0);
        }
    }

    protected void prepareHiddenBones(ItemDisplayContext transformType) {
        if (this.gunStack == null || this.gunStack.m_41619_()) {
            return;
        }
        Map<AttachmentType, ArrayList<Modules.Attachment>> gunAttachments = this.gun.getModules().getAttachments();
        this.hiddenBones.clear();
        gunAttachments.forEach((type, typeAttachments) -> {
            ItemStack item = Gun.getAttachmentItem(type, this.gunStack);
            typeAttachments.forEach(attachment -> {
                if (this.shouldRenderAttachment((Modules.Attachment)attachment, item)) {
                    if (transformType != ItemDisplayContext.GUI) {
                        this.hiddenBones.addAll(attachment.getHidden());
                    }
                } else {
                    this.hiddenBones.add(attachment.getName());
                    this.hiddenBones.addAll(attachment.getBones());
                }
            });
        });
    }
}

