/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.handlers;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.input.KeyBinds;
import com.nukateam.ntgl.client.render.renderers.misc.DeathFxRenderer;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.handler.ClientActions;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.ShootingHandler;
import com.nukateam.ntgl.common.foundation.entity.FlyingGib;
import com.nukateam.ntgl.common.foundation.init.ModEntityTypes;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageAttachments;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InputEvents {
    @SubscribeEvent
    public static void onKeyPressed(TickEvent.ClientTickEvent event) {
        InputEvents.handleKeys();
        InputEvents.handleDebugKeys();
    }

    private static void handleKeys() {
        InteractionHand hand;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        boolean shiftDown = minecraft.f_91066_.f_92090_.m_90857_();
        InteractionHand interactionHand = hand = shiftDown ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (player == null || !ShootingHandler.isInGame()) {
            return;
        }
        if (KeyBinds.KEY_ATTACHMENTS.m_90859_()) {
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAttachments());
        }
        if (KeyBinds.KEY_RELOAD.m_90859_()) {
            ClientReloadHandler.get().startReloading();
        }
        if (KeyBinds.KEY_UNLOAD.m_90859_()) {
            ClientReloadHandler.get().unloadAmmo(InteractionHand.MAIN_HAND);
            ClientReloadHandler.get().unloadAmmo(InteractionHand.OFF_HAND);
        }
        if (KeyBinds.KEY_INSPECT.m_90859_()) {
            ClientActions.inspectWeapon(player);
        }
        if (KeyBinds.KEY_FIRE_SELECT.m_90859_()) {
            ClientActions.switchFireMode(hand);
        }
        if (KeyBinds.KEY_AMMO_SELECT.m_90859_()) {
            ClientActions.switchAmmo(hand, player);
        }
    }

    private static void handleDebugKeys() {
        if (Ntgl.isDebugging()) {
            if (KeyBinds.KEY_DEBUG_X_ADD.m_90857_()) {
                ++ClientDebug.X;
            } else if (KeyBinds.KEY_DEBUG_Y_ADD.m_90857_()) {
                ++ClientDebug.Y;
            } else if (KeyBinds.KEY_DEBUG_Z_ADD.m_90857_()) {
                ++ClientDebug.Z;
            } else if (KeyBinds.KEY_DEBUG_X_SUB.m_90857_()) {
                --ClientDebug.X;
            } else if (KeyBinds.KEY_DEBUG_Y_SUB.m_90857_()) {
                --ClientDebug.Y;
            } else if (KeyBinds.KEY_DEBUG_Z_SUB.m_90857_()) {
                --ClientDebug.Z;
            } else if (KeyBinds.KEY_DEBUG_SHOW.m_90857_()) {
                ClientDebug.isHidden = !ClientDebug.isHidden;
            } else if (KeyBinds.KEY_DEBUG_ZERO.m_90857_()) {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                FlyingGib entity = new FlyingGib((EntityType<FlyingGib>)((EntityType)ModEntityTypes.FLYING_GIBS.get()), (Level)level);
                entity.m_146884_(Minecraft.m_91087_().f_91074_.m_20182_());
                DeathFxRenderer.addClientEntity(entity);
                ClientDebug.X = 0;
                ClientDebug.Y = 0;
                ClientDebug.Z = 0;
            }
        }
    }
}

