/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public final class BlueprintAndCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("blueprint", "and");
    private final List<ICondition> children;

    @Deprecated
    public BlueprintAndCondition(ResourceLocation location, List<ICondition> children) {
        this(children);
    }

    public BlueprintAndCondition(List<ICondition> children) {
        this.children = children;
    }

    public BlueprintAndCondition(ICondition ... children) {
        this(List.of(children));
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return !this.children.isEmpty();
    }

    public static class Serializer
    implements IConditionSerializer<BlueprintAndCondition> {
        private final ResourceLocation location = new ResourceLocation("blueprint", "and");

        public void write(JsonObject json, BlueprintAndCondition value) {
            JsonArray values = new JsonArray();
            for (ICondition child : value.children) {
                values.add((JsonElement)CraftingHelper.serialize((ICondition)child));
            }
            json.add("values", (JsonElement)values);
        }

        public BlueprintAndCondition read(JsonObject json) {
            ArrayList<ICondition> children = new ArrayList<ICondition>();
            for (JsonElement elements : GsonHelper.m_13933_((JsonObject)json, (String)"values")) {
                if (!elements.isJsonObject()) {
                    throw new JsonSyntaxException("And condition values must be an array of JsonObjects");
                }
                ICondition condition = CraftingHelper.getCondition((JsonObject)elements.getAsJsonObject());
                if (!condition.test(ICondition.IContext.EMPTY)) {
                    children.clear();
                    break;
                }
                children.add(condition);
            }
            return new BlueprintAndCondition(children);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

