/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.utils;

import com.nukateam.cgs.common.ntgl.CgsFuel;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.utils.FuelUtils;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;

public class GunUtils {
    public static boolean isAmmoEven(ItemStack stack) {
        return Gun.getAmmo((ItemStack)stack) % 2 == 0;
    }

    public static void playAttachSound(Player player, float pitch) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), (SoundEvent)ModSounds.UI_WEAPON_ATTACH.get(), SoundSource.PLAYERS, 0.5f, pitch);
    }

    public static boolean fillFuel(ItemStack gun, Player player, ItemStack fuelStack) {
        GunData gunData = new GunData(gun, (LivingEntity)player);
        boolean isSurvival = !player.m_7500_();
        Set allFuel = GunModifierHelper.getFuelTypes((GunData)gunData);
        for (FuelType fuelType : allFuel) {
            Integer maxFuel = GunModifierHelper.getMaxFuel((GunData)gunData, (FuelType)fuelType);
            int currentFuel = FuelUtils.getFuel((ItemStack)gun, (FuelType)fuelType);
            if (!fuelType.isAcceptable(fuelStack) || currentFuel >= maxFuel) continue;
            int value = 0;
            if (fuelType == FuelType.BURNABLE) {
                value = ForgeHooks.getBurnTime((ItemStack)fuelStack, null);
                if (isSurvival) {
                    fuelStack.m_41774_(1);
                }
            } else if (fuelType == FuelType.WATER) {
                value = 1000;
                if (isSurvival) {
                    fuelStack.m_41774_(1);
                    player.m_36356_(new ItemStack((ItemLike)Items.f_42446_));
                }
            } else if (fuelType == CgsFuel.AIR) {
                int gunRemaining = FuelUtils.getFuel((ItemStack)fuelStack, (FuelType)fuelType);
                float tankAir = BacktankUtil.getAir((ItemStack)fuelStack);
                float airSum = (float)gunRemaining + tankAir;
                value = Mth.m_14045_((int)((int)airSum), (int)0, (int)maxFuel);
                if (isSurvival) {
                    if (airSum <= (float)maxFuel.intValue()) {
                        GunUtils.consumeAir(fuelStack, tankAir);
                    } else {
                        float tankRemaining = airSum - (float)maxFuel.intValue();
                        GunUtils.setAir(fuelStack, tankRemaining);
                    }
                }
            }
            FuelUtils.addFuel((GunData)gunData, (FuelType)fuelType, (int)value);
            return true;
        }
        return false;
    }

    public static void consumeAir(ItemStack tank, float i) {
        CompoundTag tag = tank.m_41784_();
        int maxAir = BacktankUtil.maxAir((ItemStack)tank);
        float air = BacktankUtil.getAir((ItemStack)tank);
        float newAir = Math.max(air - i, 0.0f);
        tag.m_128350_("Air", Math.min(newAir, (float)maxAir));
        tank.m_41751_(tag);
    }

    public static void setAir(ItemStack tank, float newAir) {
        CompoundTag tag = tank.m_41784_();
        int maxAir = BacktankUtil.maxAir((ItemStack)tank);
        tag.m_128350_("Air", Math.min(newAir, (float)maxAir));
        tank.m_41751_(tag);
    }
}

