/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.handlers;

import com.nukateam.cgs.common.faundation.registry.ModGuns;
import com.nukateam.cgs.common.ntgl.CgsFuel;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.utils.FuelUtils;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.event.GunProjectileHitEvent;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunEventHandler {
    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        boolean hasExtendoGrip;
        LivingEntity shooter = event.getEntity();
        ItemStack gun = shooter.m_21120_(event.getHand());
        GunData gunData = new GunData(gun, shooter);
        boolean bl = hasExtendoGrip = shooter.m_21206_().m_41720_() == AllItems.EXTENDO_GRIP.get();
        if (hasExtendoGrip && !GunModifierHelper.isOneHanded((GunData)gunData)) {
            event.setCanceled(true);
        }
        if (gun.m_41720_() == ModGuns.NAILGUN.get() && !FuelUtils.hasFuel((GunData)gunData)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        LivingEntity shooter = event.getEntity();
        ItemStack gun = event.getStack();
        GunData data = new GunData(gun, shooter);
        Set fuel = GunModifierHelper.getFuelTypes((GunData)data);
        if (fuel.contains(FuelType.BURNABLE)) {
            FuelUtils.addFuel((GunData)data, (FuelType)FuelType.BURNABLE, (int)-1);
        }
        if (fuel.contains(FuelType.WATER)) {
            FuelUtils.addFuel((GunData)data, (FuelType)FuelType.WATER, (int)-5);
        }
        if (fuel.contains(CgsFuel.AIR)) {
            FuelUtils.addFuel((GunData)data, (FuelType)CgsFuel.AIR, (int)-5);
        }
    }

    @SubscribeEvent
    public static void onHit(GunProjectileHitEvent event) {
        LivingEntity shooter = event.getProjectile().getShooter();
        HitResult hitResult = event.getRayTrace();
        Level level = shooter.m_9236_();
        Vec3 pos = hitResult.m_82450_();
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.BLOCK) {
            int max;
            BacktankBlockEntity tankEntity;
            int airLevel;
            BlockPos blockPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
            BlockState blockState = level.m_8055_(blockPos);
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockState.m_60734_() == AllBlocks.COPPER_BACKTANK.get() && blockEntity instanceof BacktankBlockEntity && (airLevel = (tankEntity = (BacktankBlockEntity)blockEntity).getAirLevel()) >= (max = BacktankUtil.maxAir((int)0)) / 3) {
                GunEventHandler.explodeOnHit(level, blockPos);
            }
        }
    }

    public static void explodeOnHit(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            level.m_46961_(pos, false);
            level.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 6.0f, Level.ExplosionInteraction.NONE);
        }
    }
}

