/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.GumbeeperEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class GumballEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> MAXIMUM_BOUNCES = SynchedEntityData.m_135353_(GumballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.m_135353_(GumballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(GumballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(GumballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TARGETS_ON_BOUNCE = SynchedEntityData.m_135353_(GumballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPLITS_ON_HIT = SynchedEntityData.m_135353_(GumballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EXPLOSIVE = SynchedEntityData.m_135353_(GumballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private float explodeProgress;
    private float prevExplodeProgress;
    private List<Integer> hitEntityIds = new ArrayList<Integer>();
    private int bounceSoundCooldown = 0;

    public GumballEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.setColor(level.f_46441_.m_188503_(12));
    }

    public GumballEntity(Level level, LivingEntity shooter) {
        this((EntityType)ACEntityRegistry.GUMBALL.get(), level);
        this.m_5602_((Entity)shooter);
    }

    public GumballEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.GUMBALL.get(), level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(MAXIMUM_BOUNCES, (Object)5);
        this.f_19804_.m_135372_(BOUNCES, (Object)0);
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(2.0f));
        this.f_19804_.m_135372_(TARGETS_ON_BOUNCE, (Object)false);
        this.f_19804_.m_135372_(SPLITS_ON_HIT, (Object)false);
        this.f_19804_.m_135372_(EXPLOSIVE, (Object)false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevExplodeProgress = this.explodeProgress;
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
        } else {
            this.m_20090_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if (this.isExplosive() && this.getBounces() >= this.getMaximumBounces()) {
            if (this.explodeProgress > 20.0f) {
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_255391_(this.m_19749_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 2.0f, false, Level.ExplosionInteraction.NONE);
                    this.m_146870_();
                }
            } else {
                this.explodeProgress += 1.0f;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + (double)0.4f, this.m_20189_(), 0.0, (double)0.1f, 0.0);
        }
        if (this.bounceSoundCooldown > 0) {
            --this.bounceSoundCooldown;
        }
    }

    public void bounceFromDirection(Direction hitDirection) {
        boolean flag = false;
        if (this.getBounces() > this.getMaximumBounces() - 1 && this.isExplosive()) {
            this.m_20256_(Vec3.f_82478_);
            this.setBounces(this.getMaximumBounces());
            return;
        }
        if (this.targetsOnBounce()) {
            Entity shooter = this.m_19749_();
            Vec3 position = this.m_146892_();
            LivingEntity nearestBounceTarget = null;
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, new AABB(position.m_82520_(-10.0, -10.0, -10.0), position.m_82520_(10.0, 10.0, 10.0)))) {
                if (shooter != null && (entity.m_7306_(shooter) || entity.m_7307_(shooter)) || this.hitEntityIds.contains(entity.m_19879_()) || nearestBounceTarget != null && !(entity.m_20270_((Entity)this) < nearestBounceTarget.m_20270_((Entity)this))) continue;
                nearestBounceTarget = entity;
            }
            if (nearestBounceTarget != null) {
                flag = true;
                if (!this.m_9236_().f_46443_) {
                    this.setBounces(this.getBounces() + 1);
                }
                if (this.getBounces() > this.getMaximumBounces()) {
                    this.m_146870_();
                } else {
                    Vec3 vec3 = nearestBounceTarget.m_146892_().m_82546_(this.m_20182_()).m_82541_().m_82490_((double)0.8f);
                    this.m_20334_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
            }
        }
        if (this.bounceSoundCooldown == 0) {
            this.bounceSoundCooldown = 5;
            this.m_216990_((SoundEvent)ACSoundRegistry.GUMBALL_BOUNCE.get());
        }
        if (!flag) {
            Vec3 deltaMovement = this.m_20184_();
            double x = deltaMovement.m_7096_();
            double y = deltaMovement.m_7098_();
            double z = deltaMovement.m_7094_();
            switch (hitDirection.m_122434_()) {
                case X: {
                    x = -x * (double)0.8f;
                    break;
                }
                case Y: {
                    y = -y * 0.5;
                    break;
                }
                case Z: {
                    z = -z * (double)0.8f;
                }
            }
            if (!this.m_9236_().f_46443_) {
                this.setBounces(this.getBounces() + 1);
            }
            if (this.getBounces() > this.getMaximumBounces()) {
                this.m_146870_();
            } else {
                this.m_20334_(x, y, z);
            }
        }
    }

    public int getMaximumBounces() {
        return (Integer)this.f_19804_.m_135370_(MAXIMUM_BOUNCES);
    }

    public void setMaximumBounces(int bounces) {
        this.f_19804_.m_135381_(MAXIMUM_BOUNCES, (Object)bounces);
    }

    public int getBounces() {
        return (Integer)this.f_19804_.m_135370_(BOUNCES);
    }

    public void setBounces(int bounces) {
        this.f_19804_.m_135381_(BOUNCES, (Object)bounces);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public boolean targetsOnBounce() {
        return (Boolean)this.f_19804_.m_135370_(TARGETS_ON_BOUNCE);
    }

    public void setTargetsOnBounce(boolean targets) {
        this.f_19804_.m_135381_(TARGETS_ON_BOUNCE, (Object)targets);
    }

    public boolean splitsOnHit() {
        return (Boolean)this.f_19804_.m_135370_(SPLITS_ON_HIT);
    }

    public void setSplitsOnHit(boolean splits) {
        this.f_19804_.m_135381_(SPLITS_ON_HIT, (Object)splits);
    }

    public boolean isExplosive() {
        return (Boolean)this.f_19804_.m_135370_(EXPLOSIVE);
    }

    public void setExplosive(boolean explosive) {
        this.f_19804_.m_135381_(EXPLOSIVE, (Object)explosive);
    }

    protected float m_7139_() {
        return 0.08f;
    }

    protected void m_6532_(HitResult hitResult) {
        EntityHitResult entityHitResult;
        super.m_6532_(hitResult);
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockState state = this.m_9236_().m_8055_(blockHitResult.m_82425_());
            if (!state.m_60812_((BlockGetter)this.m_9236_(), blockHitResult.m_82425_()).m_83281_()) {
                this.bounceFromDirection(blockHitResult.m_82434_());
            }
        } else if (hitResult instanceof EntityHitResult && !this.m_150171_((entityHitResult = (EntityHitResult)hitResult).m_82443_()) && !(entityHitResult.m_82443_() instanceof GumballEntity)) {
            this.hitEntityIds.add(entityHitResult.m_82443_().m_19879_());
            Vec3 vec3 = entityHitResult.m_82443_().m_146892_().m_82546_(this.m_146892_());
            float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
            if (!this.splitsOnHit()) {
                this.bounceFromDirection(Direction.m_122364_((double)f));
            }
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity living;
        LicowitchEntity witch;
        GumbeeperEntity gumbeeper;
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        float damage = this.getDamage();
        if (owner instanceof GumbeeperEntity && (gumbeeper = (GumbeeperEntity)owner).getPossessedByLicowitchId() != -1 && (witch = gumbeeper.getPossessingLicowitch(this.m_9236_())) != null && entity instanceof LivingEntity && witch.isFriendlyFire(living = (LivingEntity)entity)) {
            return;
        }
        DamageSource damageSource = ACDamageTypes.causeGumballDamage(entity.m_9236_().m_9598_(), owner);
        if (owner == null || !entity.m_7306_(owner) && !entity.m_7307_(owner) && !owner.m_7307_(entity)) {
            this.m_216990_((SoundEvent)ACSoundRegistry.GUMBALL_HIT.get());
            entity.m_6469_(damageSource, damage);
        }
        if (this.splitsOnHit()) {
            for (int i = 0; i < 3; ++i) {
                GumballEntity gumballEntity = (GumballEntity)((EntityType)ACEntityRegistry.GUMBALL.get()).m_20615_(this.m_9236_());
                Vec3 vec3 = this.m_20184_().m_82541_();
                float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
                Vec3 vec31 = new Vec3(0.0, 0.0, this.isExplosive() ? (double)0.7f : 1.5).m_82524_((float)(-Math.toRadians(f + 30.0f - 30.0f * (float)i)));
                gumballEntity.m_146884_(entity.m_146892_().m_82549_(vec31));
                gumballEntity.m_20256_(vec31);
                gumballEntity.setSplitsOnHit(false);
                gumballEntity.setDamage(this.getDamage());
                gumballEntity.setTargetsOnBounce(this.targetsOnBounce());
                gumballEntity.setExplosive(this.isExplosive());
                gumballEntity.setMaximumBounces(this.getMaximumBounces());
                this.m_9236_().m_7967_((Entity)gumballEntity);
            }
            this.m_146870_();
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Color", this.getColor());
    }

    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setColor(compoundTag.m_128451_("Color"));
    }

    public float getExplodeProgress(float partialTicks) {
        return (this.prevExplodeProgress + (this.explodeProgress - this.prevExplodeProgress) * partialTicks) / 20.0f;
    }
}

