/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity.layer;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.model.TremorzillaModel;
import com.github.alexmodguy.alexscaves.client.render.entity.TremorzillaRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;

public class TremorzillaRiderLayer
extends RenderLayer<TremorzillaEntity, TremorzillaModel> {
    public TremorzillaRiderLayer(TremorzillaRenderer render) {
        super((RenderLayerParent)render);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, TremorzillaEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float bodyYaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTicks;
        if (entity.m_20160_()) {
            float swimProgress = entity.m_20998_(partialTicks);
            float burnProgress = entity.getBeamProgress(partialTicks);
            for (Entity passenger : entity.m_20197_()) {
                if (passenger == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) continue;
                poseStack.m_85836_();
                ((TremorzillaModel)this.m_117386_()).translateToNeck(poseStack);
                poseStack.m_252880_(0.0f, 0.5f - burnProgress * 0.5f - swimProgress * 0.5f, 0.35f - burnProgress * 0.5f - swimProgress * 0.5f);
                poseStack.m_252781_(Axis.f_252495_.m_252977_(190.0f - burnProgress * 40.0f));
                poseStack.m_252781_(Axis.f_252392_.m_252977_(360.0f - bodyYaw));
                AlexsCaves.PROXY.releaseRenderingEntity(passenger.m_20148_());
                TremorzillaRiderLayer.renderPassenger(passenger, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, bufferIn, packedLightIn);
                AlexsCaves.PROXY.blockRenderingEntity(passenger.m_20148_());
                poseStack.m_85849_();
            }
        }
    }

    public static <E extends Entity> void renderPassenger(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            try {
                render = manager.m_114382_(entityIn);
                if (render == null) break block4;
                try {
                    render.m_7392_(entityIn, yaw, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.m_127521_((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
                entityIn.m_7976_(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
                crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
                crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }
}

