/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SundropParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float initialSize;
    private BlockPos blockPos;

    protected SundropParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = spriteSet;
        this.m_108339_(this.sprites);
        this.f_107226_ = 0.0f;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        this.m_107250_(2.5f, 2.5f);
        this.f_107663_ = this.initialSize = 1.1f + world.f_46441_.m_188501_() * 0.4f;
        this.f_107225_ = 80 + world.f_46441_.m_188503_(40);
        this.f_172258_ = 0.99f;
        this.m_107271_(0.0f);
    }

    public void m_5989_() {
        this.m_108339_(this.sprites);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        float ageProgress = (float)this.f_107224_ / (float)this.f_107225_;
        float flicker = 0.5f + (float)(Math.sin((float)this.f_107224_ * 0.2f) + 1.0) * 0.25f;
        float ageAlpha = (float)Math.sin((double)Mth.m_14116_((float)ageProgress) * Math.PI);
        this.m_107271_(flicker * ageAlpha);
        this.f_107663_ = this.initialSize + flicker * 0.1f;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)this.f_172258_;
            this.f_107216_ *= (double)this.f_172258_;
            this.f_107217_ *= (double)this.f_172258_;
        }
        if (!this.f_107208_.m_8055_(this.blockPos).m_60713_((Block)ACBlockRegistry.SUNDROP.get())) {
            this.m_107274_();
        }
    }

    public void m_107274_() {
        super.m_107274_();
        ((ClientProxy)AlexsCaves.PROXY).removeParticleAt(this.blockPos);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SundropParticle particle = new SundropParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return particle;
        }
    }
}

