/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.sonar;

import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teamabnormals.blueprint.core.sonar.OnlineRequest;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class OnlineImageCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path cacheFolder;
    private final Path cacheFile;
    private final Map<String, ResourceLocation> locationCache;
    private final Set<String> errored;
    private final Map<String, CompletableFuture<ResourceLocation>> requested;
    private final Map<String, Long> textureCache;
    private final long textureCacheTime;
    private JsonObject cacheFileData;

    public OnlineImageCache(String domain, long textureCacheTime, TimeUnit unit) {
        this.cacheFolder = Minecraft.m_91087_().f_91069_.toPath().resolve(domain + "-online-image-cache");
        this.cacheFile = this.cacheFolder.resolve("cache.json");
        this.locationCache = new HashMap<String, ResourceLocation>();
        this.errored = new HashSet<String>();
        this.requested = new HashMap<String, CompletableFuture<ResourceLocation>>();
        this.textureCache = new HashMap<String, Long>();
        this.textureCacheTime = unit.toMillis(textureCacheTime);
        if (Files.exists(this.cacheFile, new LinkOption[0])) {
            try (InputStreamReader is = new InputStreamReader(new FileInputStream(this.cacheFile.toFile()));){
                this.cacheFileData = new JsonParser().parse((Reader)is).getAsJsonObject();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load cache from '" + this.cacheFile + "'", (Throwable)e);
                this.cacheFileData = new JsonObject();
            }
        } else {
            this.cacheFileData = new JsonObject();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private boolean hasTextureExpired(String hash) {
        return this.textureCacheTime > 0L && (!this.textureCache.containsKey(hash) || System.currentTimeMillis() - this.textureCache.get(hash) > 0L);
    }

    private boolean hasExpired(String hash) {
        return !this.cacheFileData.has(hash) || this.cacheFileData.get(hash).getAsLong() != -1L && System.currentTimeMillis() - this.cacheFileData.get(hash).getAsLong() > 0L;
    }

    @Nullable
    private synchronized CompletableFuture<ResourceLocation> loadCache(String hash, ResourceLocation location) {
        if (!Files.exists(this.cacheFolder, new LinkOption[0])) {
            return null;
        }
        Path imageFile = this.cacheFolder.resolve(hash);
        if (!Files.exists(imageFile, new LinkOption[0])) {
            return null;
        }
        if (this.hasExpired(hash)) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> {
            NativeImage nativeImage;
            FileInputStream is = new FileInputStream(imageFile.toFile());
            try {
                nativeImage = NativeImage.m_85058_((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load image with hash '" + hash + "' from cache. Deleting", (Throwable)e);
                    return null;
                }
            }
            is.close();
            return nativeImage;
        }, Util.m_183992_()).thenApplyAsync(image -> {
            if (image == null) {
                try {
                    this.cacheFileData.remove(hash);
                    Files.delete(imageFile);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to delete image with hash '" + hash + "' from cache.", (Throwable)e);
                }
                this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
                this.errored.add(hash);
                return MissingTextureAtlasSprite.m_118071_();
            }
            Minecraft.m_91087_().m_91097_().m_118495_(location, (AbstractTexture)new DynamicTexture(image));
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            return location;
        }, command -> RenderSystem.recordRenderCall(command::run));
    }

    private synchronized void writeCache(String hash, NativeImage image, long expirationDate) throws IOException {
        if (!Files.exists(this.cacheFolder, new LinkOption[0])) {
            Files.createDirectories(this.cacheFolder, new FileAttribute[0]);
        }
        if (!Files.exists(this.cacheFile, new LinkOption[0])) {
            Files.createFile(this.cacheFile, new FileAttribute[0]);
        }
        this.cacheFileData.addProperty(hash, (Number)expirationDate);
        try (FileOutputStream os = new FileOutputStream(this.cacheFile.toFile());){
            IOUtils.write((String)this.cacheFileData.toString(), (OutputStream)os, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write cache to file.", (Throwable)e);
        }
        image.m_85066_(this.cacheFolder.resolve(hash));
    }

    public CompletableFuture<ResourceLocation> requestTexture(String url) {
        String hash = DigestUtils.md5Hex((String)url);
        if (this.errored.contains(hash)) {
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            return CompletableFuture.completedFuture(MissingTextureAtlasSprite.m_118071_());
        }
        ResourceLocation location = this.locationCache.computeIfAbsent(hash, key -> new ResourceLocation("blueprint", key));
        if (Minecraft.m_91087_().m_91097_().m_174786_(location, null) != null) {
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            return CompletableFuture.completedFuture(location);
        }
        if (this.requested.containsKey(hash)) {
            return this.requested.get(hash);
        }
        CompletableFuture<ResourceLocation> cachedFuture = this.loadCache(hash, location);
        if (cachedFuture != null) {
            this.requested.put(hash, cachedFuture);
            return cachedFuture;
        }
        LOGGER.info("Requesting image from '" + hash + "'");
        CompletionStage future = ((CompletableFuture)OnlineRequest.request(url).thenApplyAsync(result -> {
            if (result == null) {
                return null;
            }
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)result);
                this.writeCache(hash, image, System.currentTimeMillis() + this.textureCacheTime);
                return image;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load online texture from '" + url + "'. Using missing texture sprite.", (Throwable)e);
                return null;
            }
        })).thenApplyAsync(image -> {
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            if (image == null) {
                this.errored.add(hash);
                return MissingTextureAtlasSprite.m_118071_();
            }
            Minecraft.m_91087_().m_91097_().m_118495_(location, (AbstractTexture)new DynamicTexture(image));
            return location;
        }, command -> RenderSystem.recordRenderCall(command::run));
        this.requested.put(hash, (CompletableFuture<ResourceLocation>)future);
        return future;
    }

    @SubscribeEvent
    public void onEvent(TickEvent.ClientTickEvent event) {
        this.locationCache.entrySet().removeIf(entry -> Minecraft.m_91087_().m_91097_().m_174786_((ResourceLocation)entry.getValue(), null) == null);
        this.locationCache.forEach((hash, location) -> {
            if (this.hasTextureExpired((String)hash)) {
                Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91097_().m_118513_(location));
            }
        });
        this.errored.removeIf(this::hasTextureExpired);
        this.requested.values().removeIf(CompletableFuture::isDone);
    }
}

