/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.vibrativevoice;

import com.codinglitch.lexiconfig.classes.LexiconHolding;
import com.codinglitch.vibrativevoice.CommonVibrativePlugin;
import com.codinglitch.vibrativevoice.CommonVibrativeVoice;
import com.codinglitch.vibrativevoice.VibrativeVoiceApi;
import com.codinglitch.vibrativevoice.VibrativeVoiceConfig;
import com.codinglitch.vibrativevoice.VibrativeVoiceLibrary;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class VibrativeVoiceApiImpl
extends VibrativeVoiceApi {
    private final ConcurrentHashMap<UUID, Long> timestamps = new ConcurrentHashMap();
    public final ConcurrentHashMap<UUID, Peak> loudnesses = new ConcurrentHashMap();

    @Override
    public boolean applyRestriction(VibrativeVoiceApi.RestrictionType restrictionType, boolean flag) {
        Object restriction = VibrativeVoiceLibrary.CONFIG.restrictions.getEntry(restrictionType.toString().toLowerCase());
        if (restriction == null) {
            CommonVibrativeVoice.warn("Invalid restriction type {}!", new Object[]{restrictionType});
            return false;
        }
        return (Boolean)restriction == false || flag;
    }

    @Override
    public <T> T getConfigEntry(String path, T defaultReturn) {
        String[] paths;
        VibrativeVoiceConfig currentHolder = VibrativeVoiceLibrary.CONFIG;
        for (String name : paths = path.split("\\.")) {
            Object entry = currentHolder.getEntry(name);
            if (!(entry instanceof LexiconHolding)) {
                return (T)entry;
            }
            LexiconHolding holding = (LexiconHolding)entry;
            currentHolder = holding;
        }
        return defaultReturn;
    }

    @Override
    public void trySendVibration(UUID uuid, BlockPos location, Level level, VibrativeVoiceApi.VibrationType type) {
        this.trySendVibration(uuid, location, level, type, (int)VibrativeVoiceLibrary.CONFIG.cooldownDuration);
    }

    @Override
    public void trySendVibration(UUID uuid, Entity entity, Level level, VibrativeVoiceApi.VibrationType type) {
        this.trySendVibration(uuid, entity, level, type, (int)VibrativeVoiceLibrary.CONFIG.cooldownDuration);
    }

    @Override
    public void trySendVibration(Entity entity, Level level, VibrativeVoiceApi.VibrationType type) {
        this.trySendVibration(entity.m_20148_(), entity, level, type, (int)VibrativeVoiceLibrary.CONFIG.cooldownDuration);
    }

    @Override
    public void trySendVibration(UUID uuid, BlockPos location, Level level, VibrativeVoiceApi.VibrationType type, int cooldown) {
        if (!this.isOnCooldown(uuid, level)) {
            this.setCooldown(uuid, level, cooldown);
            this.sendVibration(location, level, type);
        }
    }

    @Override
    public void trySendVibration(UUID uuid, Entity entity, Level level, VibrativeVoiceApi.VibrationType type, int cooldown) {
        if (!this.isOnCooldown(uuid, level)) {
            this.setCooldown(uuid, level, cooldown);
            this.sendVibration(entity, level, type);
        }
    }

    @Override
    public void sendVibration(BlockPos location, Level level, VibrativeVoiceApi.VibrationType vibrationType) {
        level.m_7654_().execute(() -> {
            BlockState state = level.m_8055_(location);
            level.m_220407_(this.getEvent(vibrationType), location, GameEvent.Context.m_223722_((BlockState)state));
        });
    }

    @Override
    public void sendVibration(Entity entity, Level level, VibrativeVoiceApi.VibrationType vibrationType) {
        level.m_7654_().execute(() -> entity.m_146850_(this.getEvent(vibrationType)));
    }

    @Override
    public GameEvent getEvent(VibrativeVoiceApi.VibrationType type) {
        switch (type) {
            case WEAK: {
                return CommonVibrativeVoice.WEAK_VIBRATION_EVENT;
            }
            case STRONG: {
                return CommonVibrativeVoice.STRONG_VIBRATION_EVENT;
            }
        }
        return CommonVibrativeVoice.WEAK_VIBRATION_EVENT;
    }

    @Override
    public double getPlayerLoudness(Player player) {
        return this.loudnesses.containsKey(player.m_20148_()) ? this.loudnesses.get((Object)player.m_20148_()).volume : 0.0;
    }

    @Override
    public void setPlayerLoudness(Player player, double loudness, long timestamp) {
        UUID uuid = player.m_20148_();
        if (this.loudnesses.containsKey(uuid)) {
            Peak lastPeak = this.loudnesses.get(uuid);
            if (timestamp - lastPeak.timestamp < (long)VibrativeVoiceLibrary.CONFIG.peakDuration.intValue() && loudness <= lastPeak.volume) {
                return;
            }
        }
        this.loudnesses.put(uuid, new Peak(loudness, timestamp));
    }

    @Override
    @Nullable
    public VibrativeVoiceApi.VibrationType getQualifyingType(byte[] data) {
        return this.getQualifyingType(data, 1.0f);
    }

    @Override
    @Nullable
    public VibrativeVoiceApi.VibrationType getQualifyingType(byte[] data, float volumeFactor) {
        return this.getQualifyingType(this.getVolume(data) * (double)volumeFactor);
    }

    @Override
    @Nullable
    public VibrativeVoiceApi.VibrationType getQualifyingType(short[] decoded) {
        return this.getQualifyingType(decoded, 1.0f);
    }

    @Override
    @Nullable
    public VibrativeVoiceApi.VibrationType getQualifyingType(short[] decoded, float volumeFactor) {
        return this.getQualifyingType(this.getVolume(decoded) * (double)volumeFactor);
    }

    @Override
    @Nullable
    public VibrativeVoiceApi.VibrationType getQualifyingType(double volume) {
        if (volume > VibrativeVoiceLibrary.CONFIG.strongVibrationThreshold) {
            return VibrativeVoiceApi.VibrationType.STRONG;
        }
        if (volume > VibrativeVoiceLibrary.CONFIG.weakVibrationThreshold) {
            return VibrativeVoiceApi.VibrationType.WEAK;
        }
        return null;
    }

    @Override
    public double getVolume(byte[] data) {
        OpusDecoder decoder = CommonVibrativePlugin.INSTANCE.getDecoder();
        decoder.resetState();
        return this.getVolume(decoder.decode(data));
    }

    @Override
    public double getVolume(short[] decoded) {
        if (decoded.length == 0) {
            return 0.0;
        }
        double average = 0.0;
        for (short sample : decoded) {
            average += (double)sample;
        }
        return Math.sqrt(Math.abs(average /= (double)decoded.length));
    }

    @Override
    public void setCooldown(UUID uuid, Level level, int cooldown) {
        this.timestamps.put(uuid, level.m_46467_() + (long)cooldown);
    }

    @Override
    public long getTimestamp(UUID uuid) {
        return this.timestamps.get(uuid);
    }

    @Override
    public boolean isOnCooldown(UUID uuid, Level level) {
        long time = level.m_46467_();
        return time < this.timestamps.getOrDefault(uuid, time);
    }

    public record Peak(double volume, long timestamp) {
    }
}

