/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.vibrativevoice;

import com.codinglitch.vibrativevoice.VibrativeVoiceApi;
import com.codinglitch.vibrativevoice.VibrativeVoiceApiImpl;
import com.codinglitch.vibrativevoice.VibrativeVoiceLibrary;
import com.codinglitch.vibrativevoice.platform.Services;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonVibrativeVoice {
    public static VibrativeVoiceApi API = new VibrativeVoiceApiImpl();
    public static final String ID = "vibrativevoice";
    private static final Logger LOGGER = LogManager.getLogger((String)"vibrativevoice");
    public static final Map<ResourceLocation, GameEvent> FREQUENCY_GAME_EVENTS = new HashMap<ResourceLocation, GameEvent>();
    public static GameEvent WEAK_VIBRATION_EVENT;
    public static GameEvent STRONG_VIBRATION_EVENT;
    public static final MemoryModuleType<Double> LOUDEST_PLAYER;

    public static ResourceLocation id(String ... arguments) {
        return CommonVibrativeVoice.id((CharSequence)"", arguments);
    }

    public static ResourceLocation id(CharSequence delimiter, String ... arguments) {
        return new ResourceLocation(ID, String.join(delimiter, arguments));
    }

    public static void info(Object object, Object ... substitutions) {
        LOGGER.info(String.valueOf(object), substitutions);
    }

    public static void debug(Object object, Object ... substitutions) {
        LOGGER.debug(String.valueOf(object), substitutions);
    }

    public static void warn(Object object, Object ... substitutions) {
        LOGGER.warn(String.valueOf(object), substitutions);
    }

    public static void error(Object object, Object ... substitutions) {
        LOGGER.error(String.valueOf(object), substitutions);
    }

    public static <T> T loadService(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        CommonVibrativeVoice.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static void registerFrequencyGameEvent(ResourceLocation location, GameEvent gameEvent) {
        FREQUENCY_GAME_EVENTS.put(location, gameEvent);
    }

    private static <U> MemoryModuleType<U> registerMemoryType(String name, Codec<U> codec) {
        return Services.PLATFORM.registerMemoryType(name, codec);
    }

    public static void makeGameEvents() {
        WEAK_VIBRATION_EVENT = new GameEvent("weak_voice_vibration", 16);
        STRONG_VIBRATION_EVENT = new GameEvent("strong_voice_vibration", 16);
        CommonVibrativeVoice.registerFrequencyGameEvent(CommonVibrativeVoice.id("weak_voice_vibration"), WEAK_VIBRATION_EVENT);
        CommonVibrativeVoice.registerFrequencyGameEvent(CommonVibrativeVoice.id("strong_voice_vibration"), STRONG_VIBRATION_EVENT);
        Object2IntFunction map = (Object2IntFunction)VibrationSystem.f_279561_;
        FREQUENCY_GAME_EVENTS.forEach((location, gameEvent) -> map.put(gameEvent, VibrativeVoiceLibrary.CONFIG.frequency));
    }

    public static void initialize() {
    }

    static {
        LOUDEST_PLAYER = CommonVibrativeVoice.registerMemoryType("loudest_player", Codec.doubleRange((double)0.0, (double)50.0));
    }
}

