/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.ContextAwareAnimatableManager;
import software.bernie.geckolib.util.RenderUtils;

public interface GeoItem
extends SingletonGeoAnimatable {
    public static final String ID_NBT_KEY = "GeckoLibID";

    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        SingletonGeoAnimatable.registerSyncedAnimatable(animatable);
    }

    public static long getId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Long.MAX_VALUE;
        }
        return tag.m_128454_(ID_NBT_KEY);
    }

    public static long getOrAssignId(ItemStack stack, ServerLevel level) {
        CompoundTag tag = stack.m_41784_();
        long id = tag.m_128454_(ID_NBT_KEY);
        if (tag.m_128425_(ID_NBT_KEY, 99)) {
            return id;
        }
        id = AnimatableIdCache.getFreeId(level);
        tag.m_128356_(ID_NBT_KEY, id);
        return id;
    }

    @Override
    default public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    default public boolean isPerspectiveAware() {
        return false;
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        if (this.isPerspectiveAware()) {
            return new ContextBasedAnimatableInstanceCache(this);
        }
        return SingletonGeoAnimatable.super.animatableCacheOverride();
    }

    public static class ContextBasedAnimatableInstanceCache
    extends SingletonAnimatableInstanceCache {
        public ContextBasedAnimatableInstanceCache(GeoAnimatable animatable) {
            super(animatable);
        }

        @Override
        public AnimatableManager<?> getManagerForId(long uniqueId) {
            if (!this.managers.containsKey(uniqueId)) {
                this.managers.put(uniqueId, (Object)new ContextAwareAnimatableManager<GeoItem, ItemDisplayContext>(this.animatable){

                    @Override
                    protected Map<ItemDisplayContext, AnimatableManager<GeoItem>> buildContextOptions(GeoAnimatable animatable) {
                        EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>> map = new EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>>(ItemDisplayContext.class);
                        for (ItemDisplayContext context : ItemDisplayContext.values()) {
                            map.put(context, new AnimatableManager(animatable));
                        }
                        return map;
                    }

                    @Override
                    public ItemDisplayContext getCurrentContext() {
                        ItemDisplayContext context = this.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
                        return context == null ? ItemDisplayContext.NONE : context;
                    }
                });
            }
            return (AnimatableManager)this.managers.get(uniqueId);
        }
    }
}

