/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.hamsters.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TunnelBlock
extends Block {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH);
        enumMap.put(Direction.EAST, EAST);
        enumMap.put(Direction.SOUTH, SOUTH);
        enumMap.put(Direction.WEST, WEST);
        enumMap.put(Direction.UP, UP);
        enumMap.put(Direction.DOWN, DOWN);
    })));
    protected static final VoxelShape SOLID_LEFT = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOLID_RIGHT = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOLID_FRONT = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOLID_BACK = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOLID_TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOLID_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SINGLE_Y = Shapes.m_83124_((VoxelShape)SOLID_LEFT, (VoxelShape[])new VoxelShape[]{SOLID_RIGHT, SOLID_FRONT, SOLID_BACK});
    protected static final VoxelShape SINGLE_X = Shapes.m_83124_((VoxelShape)SOLID_FRONT, (VoxelShape[])new VoxelShape[]{SOLID_BACK, SOLID_TOP, SOLID_BOTTOM});
    protected static final VoxelShape SINGLE_Z = Shapes.m_83124_((VoxelShape)SOLID_LEFT, (VoxelShape[])new VoxelShape[]{SOLID_RIGHT, SOLID_TOP, SOLID_BOTTOM});

    public TunnelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.m_21120_(interactionHand).m_41619_() && !player.m_6144_()) {
            player.m_6021_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.2, (double)blockPos.m_123343_() + 0.5);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape shape = Shapes.m_83040_();
        if (((Boolean)blockState.m_61143_((Property)SOUTH)).booleanValue() || ((Boolean)blockState.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SOLID_LEFT, SOLID_RIGHT});
        }
        if (((Boolean)blockState.m_61143_((Property)EAST)).booleanValue() || ((Boolean)blockState.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SOLID_FRONT, SOLID_BACK});
        }
        if (!((Boolean)blockState.m_61143_((Property)UP)).booleanValue() || !((Boolean)blockState.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SOLID_TOP, SOLID_BOTTOM});
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return this.getStateForPlacement((BlockGetter)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_());
    }

    public BlockState getStateForPlacement(BlockGetter blockGetter, BlockPos blockPos) {
        BlockState blockState = blockGetter.m_8055_(blockPos.m_7495_());
        BlockState blockState2 = blockGetter.m_8055_(blockPos.m_7494_());
        BlockState blockState3 = blockGetter.m_8055_(blockPos.m_122012_());
        BlockState blockState4 = blockGetter.m_8055_(blockPos.m_122029_());
        BlockState blockState5 = blockGetter.m_8055_(blockPos.m_122019_());
        BlockState blockState6 = blockGetter.m_8055_(blockPos.m_122024_());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(blockState.m_60713_((Block)this)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(blockState2.m_60713_((Block)this)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(blockState3.m_60713_((Block)this)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(blockState4.m_60713_((Block)this)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(blockState5.m_60713_((Block)this)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(blockState6.m_60713_((Block)this)));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return (BlockState)blockState.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(blockState2.m_60713_((Block)this)));
    }

    public boolean m_6104_(BlockState blockState, BlockState blockState2, Direction direction) {
        return blockState2.m_60713_((Block)this) || super.m_6104_(blockState, blockState2, direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }
}

