/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.hamsters.block;

import com.starfish_studios.hamsters.entity.Hamster;
import com.starfish_studios.hamsters.entity.SeatEntity;
import com.starfish_studios.hamsters.registry.HamstersBlockEntities;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HamsterWheelBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected static final VoxelShape NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)13.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)15.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);

    public HamsterWheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean isMountable(BlockState state) {
        return true;
    }

    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos;
    }

    public float setRiderRotation(BlockState state, Entity entity) {
        return entity.m_146908_();
    }

    public static boolean isOccupied(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return !level.m_45976_(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    public float seatHeight(BlockState state) {
        return 0.0f;
    }

    public static Optional<Entity> getLeashed(Player player) {
        List entities = player.m_9236_().m_6249_((Entity)null, player.m_20191_().m_82400_(10.0), e -> true);
        for (Entity e2 : entities) {
            Mob mob;
            if (!(e2 instanceof Mob) || (mob = (Mob)e2).m_21524_() != player || !HamsterWheelBlock.canBePickedUp(e2)) continue;
            return Optional.of(mob);
        }
        return Optional.empty();
    }

    public static boolean ejectSeatedExceptPlayer(Level level, SeatEntity seatEntity) {
        List passengers = seatEntity.m_20197_();
        if (passengers.isEmpty()) {
            return false;
        }
        if (!level.f_46443_) {
            seatEntity.m_20153_();
        }
        return true;
    }

    public static boolean canBePickedUp(Entity passenger) {
        if (passenger instanceof Player) {
            return false;
        }
        return passenger instanceof LivingEntity;
    }

    public static void sitDown(Level level, BlockPos pos, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity == null) {
            return;
        }
        SeatEntity seat = new SeatEntity(level, pos);
        level.m_7967_((Entity)seat);
        entity.m_20329_((Entity)seat);
        level.m_46717_(pos, level.m_8055_(pos).m_60734_());
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return HamsterWheelBlock.isOccupied(level, pos) ? 15 : 0;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)HamstersBlockEntities.HAMSTER_WHEEL.get()).m_155264_(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.m_21120_(interactionHand).m_41619_() || !player.m_21120_(interactionHand).m_41619_() && !player.m_6144_()) {
            Entity entity;
            if (!level.m_7966_(player, blockPos)) {
                return InteractionResult.PASS;
            }
            if (!this.isMountable(blockState) || player.m_20159_() || player.m_6047_()) {
                return InteractionResult.PASS;
            }
            if (HamsterWheelBlock.isOccupied(level, blockPos)) {
                List seats = level.m_45976_(SeatEntity.class, new AABB(blockPos));
                Entity entity2 = ((SeatEntity)((Object)seats.get(0))).m_146895_();
                if (entity2 instanceof Hamster) {
                    Hamster hamster = (Hamster)entity2;
                    hamster.setWaitTimeWhenRunningTicks(0);
                    hamster.setWaitTimeBeforeRunTicks(hamster.m_217043_().m_188503_(200) + 600);
                }
                if (HamsterWheelBlock.ejectSeatedExceptPlayer(level, (SeatEntity)((Object)seats.get(0)))) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (HamsterWheelBlock.getLeashed(player).isPresent() && (entity = HamsterWheelBlock.getLeashed(player).get()) instanceof Hamster) {
                Hamster hamster = (Hamster)entity;
                hamster.setWaitTimeBeforeRunTicks(0);
                HamsterWheelBlock.sitDown(level, blockPos, (Entity)hamster);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP);
    }
}

