/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.worldgen.structures;

import com.ordana.spelunkery.blocks.DustBlock;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import com.ordana.spelunkery.reg.ModWorldgenFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.jetbrains.annotations.Nullable;

public class MineshaftDustCorridor
extends MineshaftPieces.MineShaftPiece {
    private final boolean hasRails;
    private final boolean dustCorridor;
    private boolean hasPlacedDust;
    private final int numSections;

    public MineshaftDustCorridor(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        super(ModWorldgenFeatures.MINESHAFT_DUST_CORRIDOR.get(), compoundTag);
        this.hasRails = compoundTag.m_128471_("hr");
        this.dustCorridor = compoundTag.m_128471_("sc");
        this.hasPlacedDust = compoundTag.m_128471_("hps");
        this.numSections = compoundTag.m_128451_("Num");
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128379_("hr", this.hasRails);
        tag.m_128379_("sc", this.dustCorridor);
        tag.m_128379_("hps", this.hasPlacedDust);
        tag.m_128405_("Num", this.numSections);
    }

    public MineshaftDustCorridor(int i, RandomSource randomSource, BoundingBox boundingBox, Direction direction, MineshaftStructure.Type type) {
        super(ModWorldgenFeatures.MINESHAFT_DUST_CORRIDOR.get(), i, type, boundingBox);
        this.m_73519_(direction);
        this.hasRails = randomSource.m_188503_(3) == 0;
        this.dustCorridor = !this.hasRails && randomSource.m_188503_(23) == 0;
        this.numSections = this.m_73549_().m_122434_() == Direction.Axis.Z ? boundingBox.m_71058_() / 5 : boundingBox.m_71056_() / 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static BoundingBox findCorridorSize(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction direction) {
        int i = random.m_188503_(3) + 2;
        while (i > 0) {
            int j = i * 5;
            BoundingBox boundingBox = switch (direction) {
                default -> new BoundingBox(0, 0, -(j - 1), 2, 2, 0);
                case Direction.SOUTH -> new BoundingBox(0, 0, 0, 2, 2, j - 1);
                case Direction.WEST -> new BoundingBox(-(j - 1), 0, 0, 0, 2, 2);
                case Direction.EAST -> new BoundingBox(0, 0, 0, j - 1, 2, 2);
            };
            boundingBox.m_162367_(x, y, z);
            if (pieces.m_141921_(boundingBox) == null) {
                return boundingBox;
            }
            --i;
        }
        return null;
    }

    public void m_214092_(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
        block24: {
            int i = this.m_73548_();
            int j = random.m_188503_(4);
            Direction direction = this.m_73549_();
            if (direction != null) {
                switch (direction) {
                    default: {
                        if (j <= 1) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)this.f_73383_.m_162395_(), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162398_() - 1), (Direction)direction, (int)i);
                            break;
                        }
                        if (j == 2) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162395_() - 1), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)this.f_73383_.m_162398_(), (Direction)Direction.WEST, (int)i);
                            break;
                        }
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162399_() + 1), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)this.f_73383_.m_162398_(), (Direction)Direction.EAST, (int)i);
                        break;
                    }
                    case SOUTH: {
                        if (j <= 1) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)this.f_73383_.m_162395_(), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162401_() + 1), (Direction)direction, (int)i);
                            break;
                        }
                        if (j == 2) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162395_() - 1), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162401_() - 3), (Direction)Direction.WEST, (int)i);
                            break;
                        }
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162399_() + 1), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162401_() - 3), (Direction)Direction.EAST, (int)i);
                        break;
                    }
                    case WEST: {
                        if (j <= 1) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162395_() - 1), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)this.f_73383_.m_162398_(), (Direction)direction, (int)i);
                            break;
                        }
                        if (j == 2) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)this.f_73383_.m_162395_(), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162398_() - 1), (Direction)Direction.NORTH, (int)i);
                            break;
                        }
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)this.f_73383_.m_162395_(), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162401_() + 1), (Direction)Direction.SOUTH, (int)i);
                        break;
                    }
                    case EAST: {
                        if (j <= 1) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162399_() + 1), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)this.f_73383_.m_162398_(), (Direction)direction, (int)i);
                            break;
                        }
                        if (j == 2) {
                            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162399_() - 3), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162398_() - 1), (Direction)Direction.NORTH, (int)i);
                            break;
                        }
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162399_() - 3), (int)(this.f_73383_.m_162396_() - 1 + random.m_188503_(3)), (int)(this.f_73383_.m_162401_() + 1), (Direction)Direction.SOUTH, (int)i);
                    }
                }
            }
            if (i >= 8) break block24;
            if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                int k = this.f_73383_.m_162395_() + 3;
                while (k + 3 <= this.f_73383_.m_162399_()) {
                    int l = random.m_188503_(5);
                    if (l == 0) {
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)k, (int)this.f_73383_.m_162396_(), (int)(this.f_73383_.m_162398_() - 1), (Direction)Direction.NORTH, (int)(i + 1));
                    } else if (l == 1) {
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)k, (int)this.f_73383_.m_162396_(), (int)(this.f_73383_.m_162401_() + 1), (Direction)Direction.SOUTH, (int)(i + 1));
                    }
                    k += 5;
                }
            } else {
                int k = this.f_73383_.m_162398_() + 3;
                while (k + 3 <= this.f_73383_.m_162401_()) {
                    int l = random.m_188503_(5);
                    if (l == 0) {
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162395_() - 1), (int)this.f_73383_.m_162396_(), (int)k, (Direction)Direction.WEST, (int)(i + 1));
                    } else if (l == 1) {
                        MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162399_() + 1), (int)this.f_73383_.m_162396_(), (int)k, (Direction)Direction.EAST, (int)(i + 1));
                    }
                    k += 5;
                }
            }
        }
    }

    protected boolean m_213787_(WorldGenLevel level, BoundingBox box, RandomSource random, int x, int y, int z, ResourceLocation lootTable) {
        BlockPos.MutableBlockPos blockPos = this.m_163582_(x, y, z);
        if (box.m_71051_((Vec3i)blockPos) && level.m_8055_((BlockPos)blockPos).m_60795_() && !level.m_8055_(blockPos.m_7495_()).m_60795_()) {
            BlockState blockState = (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)(random.m_188499_() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
            this.m_73434_(level, blockState, x, y, z, box);
            MinecartChest minecartChest = new MinecartChest((Level)level.m_6018_(), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
            minecartChest.m_38236_(lootTable, random.m_188505_());
            level.m_7967_((Entity)minecartChest);
            return true;
        }
        return false;
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        if (!this.m_227881_((LevelAccessor)level, box)) {
            int o;
            int n;
            int m = this.numSections * 5 - 1;
            BlockState blockState = this.f_227864_.m_227994_();
            this.m_73441_(level, box, 0, 0, 0, 2, 1, m, f_73382_, f_73382_, false);
            this.m_226788_(level, box, random, 0.8f, 0, 2, 0, 2, 2, m, f_73382_, f_73382_, false, false);
            if (this.dustCorridor) {
                this.m_226788_(level, box, random, 0.6f, 0, 0, 0, 2, 0, m, (BlockState)ModBlocks.DUST.get().m_49966_().m_61124_((Property)DustBlock.LAYERS_8, (Comparable)Integer.valueOf(1)), f_73382_, false, true);
                this.m_226788_(level, box, random, 0.4f, 0, 0, 0, 2, 0, m, (BlockState)ModBlocks.DUST.get().m_49966_().m_61124_((Property)DustBlock.LAYERS_8, (Comparable)Integer.valueOf(3)), f_73382_, false, true);
                this.m_226788_(level, box, random, 0.2f, 0, 0, 0, 2, 0, m, (BlockState)ModBlocks.DUST.get().m_49966_().m_61124_((Property)DustBlock.LAYERS_8, (Comparable)Integer.valueOf(5)), f_73382_, false, true);
                this.m_226788_(level, box, random, 0.05f, 0, 0, 0, 2, 0, m, (BlockState)ModBlocks.DUST.get().m_49966_().m_61124_((Property)DustBlock.LAYERS_8, (Comparable)Integer.valueOf(8)), f_73382_, false, true);
            }
            for (n = 0; n < this.numSections; ++n) {
                int q;
                BlockPos.MutableBlockPos blockPos;
                o = 2 + n * 5;
                this.placeSupport(level, box, 0, 0, o, 2, 2, random);
                this.maybePlaceDust(level, box, random, 0.1f, 0, 0, o - 1);
                this.maybePlaceDust(level, box, random, 0.1f, 2, 0, o - 1);
                this.maybePlaceDust(level, box, random, 0.1f, 0, 0, o + 1);
                this.maybePlaceDust(level, box, random, 0.1f, 2, 0, o + 1);
                this.maybePlaceDust(level, box, random, 0.05f, 0, 0, o - 2);
                this.maybePlaceDust(level, box, random, 0.05f, 2, 0, o - 2);
                this.maybePlaceDust(level, box, random, 0.05f, 0, 0, o + 2);
                this.maybePlaceDust(level, box, random, 0.05f, 2, 0, o + 2);
                this.maybePlaceWebs(level, box, random, 0.1f, 0, 2, o - 1);
                this.maybePlaceWebs(level, box, random, 0.1f, 2, 2, o - 1);
                this.maybePlaceWebs(level, box, random, 0.1f, 0, 2, o + 1);
                this.maybePlaceWebs(level, box, random, 0.1f, 2, 2, o + 1);
                this.maybePlaceWebs(level, box, random, 0.05f, 0, 2, o - 2);
                this.maybePlaceWebs(level, box, random, 0.05f, 2, 2, o - 2);
                this.maybePlaceWebs(level, box, random, 0.05f, 0, 2, o + 2);
                this.maybePlaceWebs(level, box, random, 0.05f, 2, 2, o + 2);
                if (random.m_188503_(100) == 0) {
                    this.m_213787_(level, box, random, 2, 0, o - 1, BuiltInLootTables.f_78759_);
                }
                if (random.m_188503_(100) == 0) {
                    this.m_213787_(level, box, random, 0, 0, o + 1, BuiltInLootTables.f_78759_);
                }
                if (!this.dustCorridor || this.hasPlacedDust || !box.m_71051_((Vec3i)(blockPos = this.m_163582_(1, 0, q = o - 1 + random.m_188503_(3)))) || !this.m_73414_((LevelReader)level, 1, 0, q, box)) continue;
                this.hasPlacedDust = true;
                level.m_7731_((BlockPos)blockPos, Blocks.f_50085_.m_49966_(), 2);
                BlockEntity blockEntity = level.m_7702_((BlockPos)blockPos);
                if (!(blockEntity instanceof SpawnerBlockEntity)) continue;
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                spawnerBlockEntity.m_252803_(ModEntities.DUST_BUNNY.get(), random);
            }
            for (n = 0; n <= 2; ++n) {
                for (o = 0; o <= m; ++o) {
                    this.m_227890_(level, box, blockState, n, -1, o);
                }
            }
            this.placeDoubleLowerOrUpperSupport(level, box, 0, -1, 2);
            if (this.numSections > 1) {
                o = m - 2;
                this.placeDoubleLowerOrUpperSupport(level, box, 0, -1, o);
            }
            if (this.hasRails) {
                BlockState blockState2 = (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.NORTH_SOUTH);
                for (int p = 0; p <= m; ++p) {
                    BlockState blockState3 = this.m_73398_((BlockGetter)level, 1, -1, p, box);
                    if (blockState3.m_60795_() || !blockState3.m_60804_((BlockGetter)level, (BlockPos)this.m_163582_(1, -1, p))) continue;
                    float f = this.m_73414_((LevelReader)level, 1, 0, p, box) ? 0.7f : 0.9f;
                    this.m_226803_(level, box, random, f, 1, 0, p, blockState2);
                }
            }
        }
    }

    private void placeDoubleLowerOrUpperSupport(WorldGenLevel level, BoundingBox box, int x, int y, int z) {
        BlockState blockState = this.f_227864_.m_227992_();
        BlockState blockState2 = this.f_227864_.m_227994_();
        if (this.m_73398_((BlockGetter)level, x, y, z, box).m_60713_(blockState2.m_60734_())) {
            this.fillPillarDownOrChainUp(level, blockState, x, y, z, box);
        }
        if (this.m_73398_((BlockGetter)level, x + 2, y, z, box).m_60713_(blockState2.m_60734_())) {
            this.fillPillarDownOrChainUp(level, blockState, x + 2, y, z, box);
        }
    }

    protected void m_73528_(WorldGenLevel level, BlockState state, int x, int y, int z, BoundingBox box) {
        BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(x, y, z);
        if (box.m_71051_((Vec3i)mutableBlockPos)) {
            int i = mutableBlockPos.m_123342_();
            while (this.m_163572_(level.m_8055_((BlockPos)mutableBlockPos)) && mutableBlockPos.m_123342_() > level.m_141937_() + 1) {
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
            if (this.canPlaceColumnOnTopOf((LevelReader)level, (BlockPos)mutableBlockPos, level.m_8055_((BlockPos)mutableBlockPos))) {
                while (mutableBlockPos.m_123342_() < i) {
                    mutableBlockPos.m_122173_(Direction.UP);
                    level.m_7731_((BlockPos)mutableBlockPos, state, 2);
                }
            }
        }
    }

    protected void fillPillarDownOrChainUp(WorldGenLevel level, BlockState state, int x, int y, int z, BoundingBox box) {
        BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(x, y, z);
        if (box.m_71051_((Vec3i)mutableBlockPos)) {
            int i = mutableBlockPos.m_123342_();
            int j = 1;
            boolean bl = true;
            boolean bl2 = true;
            while (bl || bl2) {
                boolean bl3;
                BlockState blockState;
                if (bl) {
                    mutableBlockPos.m_142448_(i - j);
                    blockState = level.m_8055_((BlockPos)mutableBlockPos);
                    boolean bl4 = bl3 = this.m_163572_(blockState) && !blockState.m_60713_(Blocks.f_49991_);
                    if (!bl3 && this.canPlaceColumnOnTopOf((LevelReader)level, (BlockPos)mutableBlockPos, blockState)) {
                        MineshaftDustCorridor.fillColumnBetween(level, state, mutableBlockPos, i - j + 1, i);
                        return;
                    }
                    boolean bl5 = bl = j <= 20 && bl3 && mutableBlockPos.m_123342_() > level.m_141937_() + 1;
                }
                if (bl2) {
                    mutableBlockPos.m_142448_(i + j);
                    blockState = level.m_8055_((BlockPos)mutableBlockPos);
                    bl3 = this.m_163572_(blockState);
                    if (!bl3 && this.canHangChainBelow((LevelReader)level, (BlockPos)mutableBlockPos, blockState)) {
                        level.m_7731_((BlockPos)mutableBlockPos.m_142448_(i + 1), this.f_227864_.m_227995_(), 2);
                        MineshaftDustCorridor.fillColumnBetween(level, Blocks.f_50184_.m_49966_(), mutableBlockPos, i + 2, i + j);
                        return;
                    }
                    bl2 = j <= 50 && bl3 && mutableBlockPos.m_123342_() < level.m_151558_() - 1;
                }
                ++j;
            }
        }
    }

    private static void fillColumnBetween(WorldGenLevel level, BlockState state, BlockPos.MutableBlockPos pos, int minY, int maxY) {
        for (int i = minY; i < maxY; ++i) {
            level.m_7731_((BlockPos)pos.m_142448_(i), state, 2);
        }
    }

    private boolean canPlaceColumnOnTopOf(LevelReader level, BlockPos pos, BlockState state) {
        return state.m_60783_((BlockGetter)level, pos, Direction.UP);
    }

    private boolean canHangChainBelow(LevelReader level, BlockPos pos, BlockState state) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos, (Direction)Direction.DOWN) && !(state.m_60734_() instanceof FallingBlock);
    }

    private void placeSupport(WorldGenLevel level, BoundingBox box, int minX, int minY, int z, int maxY, int maxX, RandomSource random) {
        if (this.m_227874_((BlockGetter)level, box, minX, maxX, maxY, z)) {
            BlockState blockState = this.f_227864_.m_227994_();
            BlockState blockState2 = this.f_227864_.m_227995_();
            this.m_73441_(level, box, minX, minY, z, minX, maxY - 1, z, (BlockState)blockState2.m_61124_((Property)FenceBlock.f_52312_, (Comparable)Boolean.valueOf(true)), f_73382_, false);
            this.m_73441_(level, box, maxX, minY, z, maxX, maxY - 1, z, (BlockState)blockState2.m_61124_((Property)FenceBlock.f_52310_, (Comparable)Boolean.valueOf(true)), f_73382_, false);
            if (random.m_188503_(4) == 0) {
                this.m_73441_(level, box, minX, maxY, z, minX, maxY, z, blockState, f_73382_, false);
                this.m_73441_(level, box, maxX, maxY, z, maxX, maxY, z, blockState, f_73382_, false);
            } else {
                this.m_73441_(level, box, minX, maxY, z, maxX, maxY, z, blockState, f_73382_, false);
                this.m_226803_(level, box, random, 0.05f, minX + 1, maxY, z - 1, (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)Direction.SOUTH));
                this.m_226803_(level, box, random, 0.05f, minX + 1, maxY, z + 1, (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)Direction.NORTH));
            }
        }
    }

    private void maybePlaceDust(WorldGenLevel level, BoundingBox box, RandomSource random, float chance, int x, int y, int z) {
        if (this.m_73414_((LevelReader)level, x, y, z, box) && random.m_188501_() < chance && this.hasSturdyNeighbours(level, box, x, y, z, 2)) {
            this.m_73434_(level, (BlockState)ModBlocks.DUST.get().m_49966_().m_61124_((Property)DustBlock.LAYERS_8, (Comparable)Integer.valueOf(random.m_216332_(1, 3))), x, y, z, box);
        }
    }

    private void maybePlaceWebs(WorldGenLevel level, BoundingBox box, RandomSource random, float chance, int x, int y, int z) {
        if (this.m_73414_((LevelReader)level, x, y, z, box) && random.m_188501_() < chance && this.hasSturdyNeighbours(level, box, x, y, z, 2)) {
            this.m_73434_(level, Blocks.f_50033_.m_49966_(), x, y, z, box);
        }
    }

    private boolean hasSturdyNeighbours(WorldGenLevel level, BoundingBox box, int x, int y, int z, int required) {
        BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(x, y, z);
        int i = 0;
        for (Direction direction : Direction.values()) {
            mutableBlockPos.m_122173_(direction);
            if (box.m_71051_((Vec3i)mutableBlockPos) && level.m_8055_((BlockPos)mutableBlockPos).m_60783_((BlockGetter)level, (BlockPos)mutableBlockPos, direction.m_122424_()) && ++i >= required) {
                return true;
            }
            mutableBlockPos.m_122173_(direction.m_122424_());
        }
        return false;
    }
}

