/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.mixins;

import com.mojang.authlib.GameProfile;
import com.ordana.spelunkery.items.ParachuteItem;
import com.ordana.spelunkery.utils.IParachuteEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer
implements IParachuteEntity {
    @Unique
    private ItemStack spelunkery$parachute = ItemStack.f_41583_;
    @Unique
    private int spelunkery$parachuteTicks = 0;

    protected LocalPlayerMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V", shift=At.Shift.AFTER)})
    private void checkIfHasParachute(CallbackInfo ci) {
        this.spelunkery$parachute = ParachuteItem.getParachute((LivingEntity)this);
        this.spelunkery$parachuteTicks = !this.spelunkery$parachute.m_41619_() && ParachuteItem.getActive(this.spelunkery$parachute) ? ++this.spelunkery$parachuteTicks : 0;
    }

    @Override
    public ItemStack getParachute() {
        return this.spelunkery$parachute;
    }

    @Override
    public void setParachute(ItemStack parachute) {
        this.spelunkery$parachute = parachute;
    }

    @Override
    public int getParachuteTicks() {
        return this.spelunkery$parachuteTicks;
    }
}

