/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.fungi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FloorAndSidesMushroomBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty FLOOR;
    public static final DirectionProperty FACING;
    private static final Map<Direction, VoxelShape> FACING_TO_SHAPE;
    private static final VoxelShape SHAPE;

    public FloorAndSidesMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FLOOR});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)FLOOR)).booleanValue()) {
            return SHAPE;
        }
        return FACING_TO_SHAPE.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (((Boolean)state.m_61143_((Property)FLOOR)).booleanValue()) {
            direction = Direction.UP;
        }
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)level, blockPos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = super.m_5573_(ctx);
        Level level = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        Direction dir = ctx.m_43719_();
        if (dir == Direction.DOWN) {
            blockState = (BlockState)blockState.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true));
        } else if (dir != Direction.UP) {
            blockState = (BlockState)((BlockState)blockState.m_61124_((Property)FACING, (Comparable)dir)).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(false));
        }
        if (blockState.m_60710_((LevelReader)level, blockPos)) {
            return blockState;
        }
        return null;
    }

    public boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        level.m_7471_(pos, false);
        Holder feature = null;
        if (state.m_60713_(ModBlocks.PHOSPHOR_FUNGUS.get())) {
            feature = (Holder)((Registry)level.m_9598_().m_6632_(Registries.f_256911_).get()).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Spelunkery.res("huge_phosphor_fungus_bonemeal"))).get();
        }
        if (state.m_60713_(ModBlocks.MUSHGLOOM.get())) {
            feature = (Holder)((Registry)level.m_9598_().m_6632_(Registries.f_256911_).get()).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Spelunkery.res("huge_mushgloom_bonemeal"))).get();
        }
        if (feature != null) {
            if (((ConfiguredFeature)feature.m_203334_()).m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos)) {
                return true;
            }
            level.m_7731_(pos, state, 3);
            return false;
        }
        return false;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)FLOOR) != false && (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13057_) || pos.m_123342_() < 0);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.m_188501_() < 0.4;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growMushroom(level, pos, state, random);
    }

    static {
        SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
        FLOOR = ModBlockProperties.FLOOR;
        FACING = HorizontalDirectionalBlock.f_54117_;
        FACING_TO_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)2.0, (double)2.0, (double)5.0, (double)14.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)11.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)5.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0)));
    }
}

