/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.mixin;

import com.leclowndu93150.corpsecurioscompat.Config;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={CorpseInventoryContainer.class, CorpseAdditionalContainer.class})
public abstract class CorpseContainerMixin {
    private Player cachedPlayer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history, CallbackInfo ci) {
        if (playerInventory != null) {
            this.cachedPlayer = playerInventory.f_35978_;
        }
    }

    @Inject(method={"transferItems"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void transferItemsToCurios(CallbackInfo ci) {
        block7: {
            Map curios;
            boolean isAdditional;
            CorpseContainerMixin container;
            block6: {
                int i;
                container = this;
                if (!this.cachedPlayer.m_6084_()) {
                    return;
                }
                if (!((CorpseContainerBase)container).isEditable()) {
                    return;
                }
                boolean isCorpseInv = container instanceof CorpseInventoryContainer;
                isAdditional = container instanceof CorpseAdditionalContainer;
                Optional curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.cachedPlayer).resolve();
                if (curiosOpt.isEmpty()) {
                    return;
                }
                ICuriosItemHandler curiosHandler = (ICuriosItemHandler)curiosOpt.get();
                curios = curiosHandler.getCurios();
                if (!isCorpseInv) break block6;
                CorpseInventoryContainer corpseContainer = (CorpseInventoryContainer)container;
                for (i = 0; i < corpseContainer.f_38839_.size() && i < corpseContainer.getInventorySize(); ++i) {
                    Slot slot = corpseContainer.m_38853_(i);
                    ItemStack stack = slot.m_7993_();
                    if (!this.tryTransferToCurios(stack, curios)) continue;
                    slot.m_5852_(ItemStack.f_41583_);
                }
                for (i = 0; i < corpseContainer.getCorpse().getDeath().getAdditionalItems().size(); ++i) {
                    ItemStack stack = (ItemStack)corpseContainer.getCorpse().getDeath().getAdditionalItems().get(i);
                    if (!this.tryTransferToCurios(stack, curios)) continue;
                    corpseContainer.getCorpse().getDeath().getAdditionalItems().set(i, (Object)ItemStack.f_41583_);
                }
                break block7;
            }
            if (!isAdditional) break block7;
            CorpseAdditionalContainer additionalContainer = (CorpseAdditionalContainer)container;
            for (int i = 0; i < additionalContainer.getInventorySize(); ++i) {
                ItemStack stack;
                Slot slot = additionalContainer.m_38853_(i);
                if (slot == null || !this.tryTransferToCurios(stack = slot.m_7993_(), curios)) continue;
                slot.m_5852_(ItemStack.f_41583_);
            }
        }
    }

    private boolean tryTransferToCurios(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        if (stack.m_41619_() || CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty()) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.m_41720_())) {
            return false;
        }
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (!CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).contains(entry.getKey())) continue;
            ICurioStacksHandler handler = entry.getValue();
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                if (!handler.getStacks().getStackInSlot(slot).m_41619_()) continue;
                handler.getStacks().setStackInSlot(slot, stack.m_41777_());
                return true;
            }
        }
        return false;
    }
}

