/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.forge;

import net.mehvahdjukaar.sleep_tight.client.SleepGuiOverlay;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class SleepTightForgeClient {
    public static void init() {
        MinecraftForge.EVENT_BUS.register(SleepTightForgeClient.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SleepTightForgeClient::onAddGuiLayers);
    }

    @SubscribeEvent
    public static void onRenderScreen(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InBedChatScreen) {
            InBedChatScreen s = (InBedChatScreen)screen;
            SleepGuiOverlay.renderBedScreenOverlay(s, event.getGuiGraphics(), event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public static void onInitScreen(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InBedChatScreen) {
            InBedChatScreen s = (InBedChatScreen)screen;
            SleepGuiOverlay.setupOverlay(s);
        }
    }

    @SubscribeEvent
    public static void renderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        Minecraft mc = Minecraft.m_91087_();
        if (player == mc.f_91074_ && mc.f_91066_.m_92176_().m_90612_() && player.m_20202_() instanceof BedEntity) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102808_.f_104207_ = false;
        }
    }

    public static void onAddGuiLayers(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "sleep_indicator", (IGuiOverlay)new SleepGuiOverlayImpl());
    }

    public static class SleepGuiOverlayImpl
    extends SleepGuiOverlay<ForgeGui>
    implements IGuiOverlay {
        @Override
        protected void setupOverlayRenderState(ForgeGui gui, boolean blend, boolean depthTest, ResourceLocation icons) {
            gui.setupOverlayRenderState(blend, depthTest);
        }
    }
}

