/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.network;

import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class ClientBoundSyncPlayerSleepCapMessage
implements Message {
    @Nullable
    private final UUID id;
    private final long insomniaElapse;
    private final long sleepTime;
    private final int consecutiveNights;
    private final int homeBedNights;
    private final boolean doubleBed;

    public ClientBoundSyncPlayerSleepCapMessage(FriendlyByteBuf buf) {
        this.id = buf.readBoolean() ? buf.m_130259_() : null;
        this.insomniaElapse = buf.readLong();
        this.sleepTime = buf.readLong();
        this.consecutiveNights = buf.readInt();
        this.homeBedNights = buf.readInt();
        this.doubleBed = buf.readBoolean();
    }

    public ClientBoundSyncPlayerSleepCapMessage(PlayerSleepData c) {
        this.id = c.getHomeBed();
        this.insomniaElapse = c.getInsomniaWillElapseTimeStamp();
        this.sleepTime = c.getLastWokenUpTimeStamp();
        this.consecutiveNights = c.getConsecutiveNightsSlept();
        this.homeBedNights = c.getNightsSleptInHomeBed();
        this.doubleBed = c.usingDoubleBed();
    }

    public ClientBoundSyncPlayerSleepCapMessage(Player player) {
        this(SleepTightPlatformStuff.getPlayerSleepData(player));
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(this.id != null);
        if (this.id != null) {
            buf.m_130077_(this.id);
        }
        buf.writeLong(this.insomniaElapse);
        buf.writeLong(this.sleepTime);
        buf.writeInt(this.consecutiveNights);
        buf.writeInt(this.homeBedNights);
        buf.writeBoolean(this.doubleBed);
    }

    public void handle(ChannelHandler.Context context) {
        Player p = SleepTightClient.getPlayer();
        if (p == null) {
            return;
        }
        PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData(p);
        c.acceptFromServer(this.id, this.insomniaElapse, this.sleepTime, this.consecutiveNights, this.homeBedNights, this.doubleBed);
    }
}

