/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.entities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.blocks.InfestedBedBlock;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BedbugEntity
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BedbugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BlockPos targetBed;
    private int burrowingTicks = 0;
    private int prevBurrowingTicks = 0;

    public BedbugEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public BedbugEntity(Level level) {
        super(SleepTight.BEDBUG_ENTITY.get(), level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(2, (Goal)new InfestBedGoal(this, 1.0, 20));
        this.f_21345_.m_25352_(3, (Goal)new BedbugLeapGoal((Mob)this, 0.25f));
        this.f_21345_.m_25352_(4, (Goal)new BedbugAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public float getBurrowing(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevBurrowingTicks, (float)this.burrowingTicks);
    }

    public int m_8085_() {
        return 0;
    }

    public int m_8132_() {
        return 20;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_5448_() != null) {
            this.m_21563_().m_148051_((Entity)this.m_5448_());
        }
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            this.setClimbing(this.f_19862_);
        } else {
            this.prevBurrowingTicks = this.burrowingTicks;
        }
        if (this.isBurrowing()) {
            BlockPos pos = this.m_20183_();
            BlockState feetBlockState = level.m_8055_(pos);
            if (!(feetBlockState.m_60734_() instanceof BedBlock)) {
                this.setBurrowing(false);
            } else {
                ++this.burrowingTicks;
                if (level.f_46443_) {
                    for (int i = 0; i < 6 + level.f_46441_.m_188503_(10); ++i) {
                        float x = (float)pos.m_123341_() + level.f_46441_.m_188501_();
                        float z = (float)pos.m_123343_() + level.f_46441_.m_188501_();
                        float y = (float)pos.m_123342_() + 0.5625f;
                        level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, feetBlockState), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                    }
                } else if (this.burrowingTicks > 40) {
                    if (InfestedBedBlock.infestBed(level, pos)) {
                        this.m_21373_();
                        this.m_146870_();
                        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    } else {
                        this.setBurrowing(false);
                    }
                } else if (this.burrowingTicks % 4 == 0) {
                    level.m_5594_(null, pos, SoundEvents.f_12641_, SoundSource.HOSTILE, 0.5f, 1.2f);
                }
            }
        } else if (this.burrowingTicks > 0) {
            this.burrowingTicks = Math.max(0, this.burrowingTicks - 4);
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
    }

    protected SoundEvent m_7515_() {
        return SleepTight.BEDBUG_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SleepTight.BEDBUG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return SleepTight.BEDBUG_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12422_, 0.15f, 1.0f);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplier);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public boolean isSplattered() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 3) != 0;
    }

    public boolean isBurrowing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 5) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b = climbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b);
    }

    public void setSplattered(boolean splattered) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b = splattered ? (byte)(b | 3) : (byte)(b & 0xFFFFFFFD);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b);
    }

    public void setBurrowing(boolean burrowing) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b = burrowing ? (byte)(b | 5) : (byte)(b & 0xFFFFFFFB);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b);
    }

    protected PathNavigation m_6037_(Level level) {
        return new BedbugNavigation(this, level);
    }

    public void setBedTarget(BlockPos pos) {
        this.targetBed = new BlockPos((Vec3i)pos);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("targetBed")) {
            this.targetBed = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("targetBed"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.targetBed != null) {
            compound.m_128365_("targetBed", (Tag)NbtUtils.m_129224_((BlockPos)this.targetBed));
        }
    }

    protected void onInsideBlock(BlockState state, BlockPos pos) {
        VoxelShape voxelShape;
        VoxelShape voxelShape2;
        if (state.m_60734_() instanceof DoorBlock && Shapes.m_83157_((VoxelShape)(voxelShape2 = (voxelShape = state.m_60812_((BlockGetter)this.m_9236_(), pos)).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())), (VoxelShape)Shapes.m_83064_((AABB)this.m_20191_()), (BooleanOp)BooleanOp.f_82689_)) {
            NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntity((Entity)this, (Message)ClientBoundParticleMessage.bedbugDoor(pos));
            this.m_7601_(state, new Vec3(0.5, 0.5, 0.5));
        }
        super.m_6763_(state);
    }

    protected void m_20101_() {
        AABB aABB = this.m_20191_();
        BlockPos blockPos = BlockPos.m_274561_((double)(aABB.f_82288_ + 0.001), (double)(aABB.f_82289_ + 0.001), (double)(aABB.f_82290_ + 0.001));
        BlockPos blockPos2 = BlockPos.m_274561_((double)(aABB.f_82291_ - 0.001), (double)(aABB.f_82292_ - 0.001), (double)(aABB.f_82293_ - 0.001));
        Level level = this.m_9236_();
        if (level.m_46832_(blockPos, blockPos2)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i = blockPos.m_123341_(); i <= blockPos2.m_123341_(); ++i) {
                for (int j = blockPos.m_123342_(); j <= blockPos2.m_123342_(); ++j) {
                    for (int k = blockPos.m_123343_(); k <= blockPos2.m_123343_(); ++k) {
                        mutableBlockPos.m_122178_(i, j, k);
                        BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
                        try {
                            blockState.m_60682_(level, (BlockPos)mutableBlockPos, (Entity)this);
                            this.onInsideBlock(blockState, (BlockPos)mutableBlockPos);
                            continue;
                        }
                        catch (Exception e) {
                            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Colliding entity with block");
                            CrashReportCategory crashReportCategory = crashReport.m_127514_("Block being collided with");
                            CrashReportCategory.m_178950_((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)level, (BlockPos)mutableBlockPos, (BlockState)blockState);
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            }
        }
    }

    public boolean m_7337_(Entity entity) {
        return super.m_7337_(entity);
    }

    public boolean m_20039_(BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof DoorBlock) {
            return false;
        }
        return super.m_20039_(pos, state);
    }

    public static boolean isValidBedForInfestation(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof BedBlock && block != SleepTight.INFESTED_BED && (Boolean)state.m_61143_((Property)BedBlock.f_49441_) == false;
    }

    public static AttributeSupplier.Builder makeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 9.0).m_22268_(Attributes.f_22279_, 0.325).m_22268_(Attributes.f_22281_, 1.0);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (spawnType == MobSpawnType.EVENT && level.m_46791_() != Difficulty.PEACEFUL) {
            int maxLight = CommonConfigs.BEDBUG_MAX_LIGHT.get();
            if (maxLight < 15) {
                int light = Math.max(level.m_45517_(LightLayer.BLOCK, pos), level.m_45517_(LightLayer.SKY, pos));
                return light <= maxLight;
            }
            return true;
        }
        return Monster.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    static class InfestBedGoal
    extends MoveToBlockGoal {
        private final List<BlockPos> blacklist = new ArrayList<BlockPos>();
        private final BedbugEntity bedBug;
        private final int searchRange;
        private int ticksOnTarget = 0;
        private boolean reachedTarget;

        public InfestBedGoal(BedbugEntity pathfinderMob, double speed, int searchRange) {
            super((PathfinderMob)pathfinderMob, speed, searchRange);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.TARGET));
            this.bedBug = pathfinderMob;
            this.searchRange = searchRange;
        }

        protected boolean m_25625_() {
            return this.reachedTarget;
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        public void m_8037_() {
            BlockPos blockPos = this.m_6669_();
            double dist = blockPos.m_203193_((Position)this.f_25598_.m_20182_());
            if (dist >= 1.0) {
                this.reachedTarget = false;
                ++this.f_25601_;
                if (this.m_8064_()) {
                    double s = this.f_25599_;
                    if (dist < 2.25) {
                        s /= 2.0;
                    }
                    this.f_25598_.m_21573_().m_26519_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.25, (double)blockPos.m_123343_() + 0.5, s);
                }
            } else {
                this.reachedTarget = true;
                --this.f_25601_;
            }
            if (this.m_25625_()) {
                ++this.ticksOnTarget;
                this.bedBug.setBurrowing(true);
            } else {
                this.ticksOnTarget = 0;
            }
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return BedbugEntity.isValidBedForInfestation(level.m_8055_(pos));
        }

        protected int m_6099_(PathfinderMob creature) {
            return super.m_6099_(creature) * 100;
        }

        protected boolean m_25626_() {
            if (this.bedBug.targetBed != null && this.m_6465_((LevelReader)this.f_25598_.m_9236_(), this.bedBug.targetBed)) {
                this.f_25602_ = this.bedBug.targetBed;
                return true;
            }
            List<BlockPos> v = this.findNearestBed();
            if (!v.isEmpty()) {
                this.bedBug.targetBed = v.get(0);
                this.f_25602_ = v.get(0);
                return true;
            }
            return false;
        }

        private List<BlockPos> findNearestBed() {
            BlockPos pos = this.bedBug.m_20183_();
            ServerLevel level = (ServerLevel)this.bedBug.m_9236_();
            PoiManager poiManager = level.m_8904_();
            Stream stream = poiManager.m_27181_(h -> h.m_203565_(PoiTypes.f_218060_), pos, this.searchRange, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::m_27257_).filter(p -> this.m_6465_((LevelReader)level, (BlockPos)p)).sorted(Comparator.comparingDouble(p -> p.m_123331_((Vec3i)pos))).toList();
        }
    }

    static class BedbugLeapGoal
    extends LeapAtTargetGoal {
        private final Mob mob;

        public BedbugLeapGoal(Mob mob, float f) {
            super(mob, f);
            this.mob = mob;
        }

        public void m_8056_() {
            this.mob.m_21563_().m_148051_((Entity)this.mob.m_5448_());
            super.m_8056_();
        }
    }

    static class BedbugAttackGoal
    extends MeleeAttackGoal {
        private final BedbugEntity bedbug;

        public BedbugAttackGoal(BedbugEntity spider) {
            super((PathfinderMob)spider, 1.0, true);
            this.bedbug = spider;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.bedbug.targetBed != null && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }
    }

    private static class BedbugNavigation
    extends WallClimberNavigation {
        BedbugNavigation(BedbugEntity frog, Level level) {
            super((Mob)frog, level);
        }

        protected PathFinder m_5532_(int maxVisitedNodes) {
            this.f_26508_ = new BedbugNodeEvaluator();
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, maxVisitedNodes);
        }
    }

    private static class BedbugNodeEvaluator
    extends WalkNodeEvaluator {
        protected double m_142213_(BlockPos pos) {
            BlockPos blockPos = pos.m_7495_();
            BlockState state = this.f_77312_.m_8055_(blockPos);
            if (state.m_204336_(SleepTight.BEDBUG_WALK_THROUGH)) {
                return blockPos.m_123342_();
            }
            VoxelShape voxelShape = state.m_60812_((BlockGetter)this.f_77312_, blockPos);
            return (double)blockPos.m_123342_() + (voxelShape.m_83281_() ? 0.0 : voxelShape.m_83297_(Direction.Axis.Y));
        }

        protected BlockPathTypes m_264405_(BlockGetter blockGetter, BlockPos blockPos, BlockPathTypes nodeType) {
            if (nodeType == BlockPathTypes.DOOR_OPEN || nodeType == BlockPathTypes.DOOR_WOOD_CLOSED || nodeType == BlockPathTypes.WALKABLE_DOOR) {
                return BlockPathTypes.OPEN;
            }
            if (nodeType == BlockPathTypes.BLOCKED && this.f_77312_.m_8055_(blockPos).m_60734_() instanceof BedBlock) {
                return BlockPathTypes.WALKABLE;
            }
            return super.m_264405_((BlockGetter)this.f_77312_, blockPos, nodeType);
        }
    }
}

