/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public enum HammockPart implements StringRepresentable
{
    HALF_HEAD("half_head", -1, false),
    MIDDLE("middle", 0, false),
    HALF_FOOT("half_foot", 1, false),
    HEAD("head", 0, true),
    FOOT("foot", 1, true);

    private final String name;
    private final int masterOffset;
    private final boolean onFence;
    private final float pivotOffset;

    private HammockPart(String name, int offset, boolean onRope) {
        this.name = name;
        this.masterOffset = offset;
        this.onFence = onRope;
        this.pivotOffset = onRope ? 0.3125f : 0.1875f;
    }

    public float getPivotOffset() {
        return this.pivotOffset;
    }

    public String toString() {
        return this.name;
    }

    public String m_7912_() {
        return this.name;
    }

    public boolean isFoot() {
        return this == FOOT || this == HALF_FOOT;
    }

    public HammockPart getToFootPart() {
        return switch (this) {
            case HEAD -> FOOT;
            case HALF_HEAD -> MIDDLE;
            case MIDDLE -> HALF_FOOT;
            default -> null;
        };
    }

    public HammockPart getToHeadPart() {
        return switch (this) {
            case FOOT -> HEAD;
            case MIDDLE -> HALF_HEAD;
            case HALF_FOOT -> MIDDLE;
            default -> null;
        };
    }

    @Nullable
    public Direction getConnectionDirection(Direction myDirection) {
        return switch (this) {
            case FOOT, HALF_FOOT -> myDirection.m_122424_();
            case HEAD, HALF_HEAD -> myDirection;
            default -> null;
        };
    }

    public List<Pair<Direction, HammockPart>> getPiecesDirections(Direction myDirection) {
        HammockPart p1;
        ArrayList<Pair<Direction, HammockPart>> list = new ArrayList<Pair<Direction, HammockPart>>();
        HammockPart p = this.getToHeadPart();
        if (p != null) {
            list.add(Pair.of((Object)myDirection, (Object)((Object)p)));
        }
        if ((p1 = this.getToFootPart()) != null) {
            list.add((Pair<Direction, HammockPart>)Pair.of((Object)myDirection.m_122424_(), (Object)((Object)p1)));
        }
        return list;
    }

    public int getMasterOffset() {
        return this.masterOffset;
    }

    public boolean isMaster() {
        return this.masterOffset == 0;
    }

    public boolean isOnFence() {
        return this.onFence;
    }

    @Nullable
    public Direction getRopeAttachmentDirection(Direction myDir) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FOOT, HALF_FOOT -> myDir.m_122424_();
            case HEAD, HALF_HEAD -> myDir;
            case MIDDLE -> null;
        };
    }
}

