/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.NightBagBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.NightBagItem;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class SleepGuiOverlay<T extends Gui> {
    private static boolean isHomeBed = false;
    private static boolean hasDreamerEssence = false;

    public void render(T gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        PlayerSleepData c;
        float f;
        BlockHitResult bh;
        LocalPlayer player;
        boolean laying;
        Minecraft mc = Minecraft.m_91087_();
        Options options = mc.f_91066_;
        if (options.f_92062_) {
            return;
        }
        HitResult hit = mc.f_91077_;
        boolean cooldown = ClientConfigs.INSOMNIA_COOLDOWN.get();
        boolean timer = ClientConfigs.INSOMNIA_TIMER.get();
        if (!timer && !cooldown) {
            return;
        }
        if (options.m_92176_().m_90612_() && (mc.f_91072_.m_105295_() != GameType.SPECTATOR || gui.m_93024_(hit)) && ((laying = (player = mc.f_91074_).m_20202_() instanceof BedEntity) || cooldown && (hit instanceof BlockHitResult && mc.f_91073_.m_8055_((bh = (BlockHitResult)hit).m_82425_()).m_60734_() instanceof ISleepTightBed || player.m_21205_().m_41720_() instanceof NightBagItem)) && (f = 1.0f - (c = SleepTightPlatformStuff.getPlayerSleepData((Player)player)).getInsomniaCooldown((Player)player)) < 1.0f) {
            if (laying && timer) {
                graphics.m_280488_(mc.f_91062_, "" + c.getInsomniaTimeLeft((Player)player) / 20L, 2, 2, 0xE0E0E0);
            }
            if (cooldown) {
                this.setupOverlayRenderState(gui, true, false, SleepTightClient.ICONS);
                graphics.m_280168_().m_85836_();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int j = height / 2 - 7 + 16;
                int k = width / 2 - 6;
                if (mc.f_91066_.m_232120_().m_231551_() == AttackIndicatorStatus.CROSSHAIR && player.m_36403_(0.0f) != 1.0f) {
                    j += 8;
                }
                int l = (int)(f * 11.0f);
                graphics.m_280163_(SleepTightClient.ICONS, k, j, 3.0f, 18.0f, 11, 5, 48, 48);
                graphics.m_280163_(SleepTightClient.ICONS, k, j, 19.0f, 18.0f, l, 5, 48, 48);
                graphics.m_280168_().m_85849_();
            }
        }
    }

    protected abstract void setupOverlayRenderState(T var1, boolean var2, boolean var3, ResourceLocation var4);

    public static void renderBedScreenOverlay(InBedChatScreen s, GuiGraphics graphics, int mouseX, int mouseY) {
        int x;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (ClientConfigs.SHOW_TIME.get().booleanValue()) {
            graphics.m_280430_(mc.f_91062_, SleepGuiOverlay.getCurrentTime(player.m_9236_()), 2, 2, 0xE0E0E0);
        }
        int y = s.f_96544_ - 39;
        int iconSize = 18;
        if (isHomeBed) {
            x = s.f_96543_ / 2 - 120;
            graphics.m_280163_(SleepTightClient.ICONS, x, y, 0.0f, 0.0f, iconSize, iconSize, 48, 48);
        }
        if (hasDreamerEssence) {
            x = s.f_96543_ / 2 + 120 - iconSize;
            graphics.m_280163_(SleepTightClient.ICONS, x, y, (float)iconSize, 0.0f, iconSize, iconSize, 48, 48);
        }
        if (isHomeBed && MthUtils.isWithinRectangle((int)(x = s.f_96543_ / 2 - 120), (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            PlayerSleepData data = SleepTightPlatformStuff.getPlayerSleepData((Player)player);
            double nightmare = data.getNightmareChance((Player)player, player.m_21257_().orElse(BlockPos.f_121853_));
            int bedLevel = data.getHomeBedLevel();
            ArrayList lines = new ArrayList(mc.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"gui.sleep_tight.home_bed"), 200));
            lines.addAll(mc.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.sleep_tight.bed_level", (Object[])new Object[]{bedLevel}), 200));
            lines.addAll(mc.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.sleep_tight.nightmare", (Object[])new Object[]{nightmare}), 200));
            graphics.m_280245_(mc.f_91062_, lines, mouseX, mouseY);
        }
        if (hasDreamerEssence && MthUtils.isWithinRectangle((int)(x = s.f_96543_ / 2 + 120 - iconSize), (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            graphics.m_280245_(mc.f_91062_, mc.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"gui.sleep_tight.dreamer_essence"), 200), mouseX, mouseY);
        }
    }

    private static Component getCurrentTime(Level level) {
        int time = (int)(level.m_46468_() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!ClientConfigs.TIME_FORMAT_24H.get().booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        return Component.m_237113_((String)(h + ":" + (m < 10 ? "0" : "") + m + a));
    }

    public static void setupOverlay(InBedChatScreen screen) {
        isHomeBed = false;
        hasDreamerEssence = false;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Optional p = player.m_21257_();
        if (p.isPresent()) {
            BlockPos pos = (BlockPos)p.get();
            BedData cap = PlayerSleepData.getHomeBedIfHere((Player)player, pos);
            isHomeBed = cap != null;
            hasDreamerEssence = !(player.m_9236_().m_8055_(pos).m_60734_() instanceof NightBagBlock) && DreamEssenceBlock.isInRange(pos, player.m_9236_());
        }
    }
}

