/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.sleep_tight.client.PackProvider;
import net.mehvahdjukaar.sleep_tight.common.InvigoratedEffect;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.InfestedBedBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.NightBagBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.common.entities.DreamerEssenceTargetEntity;
import net.mehvahdjukaar.sleep_tight.common.items.BedbugEggsItem;
import net.mehvahdjukaar.sleep_tight.common.items.NightBagItem;
import net.mehvahdjukaar.sleep_tight.common.network.ModCommands;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.common.tiles.InfestedBedTile;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.Util;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SleepTight {
    public static final boolean EASY_MODE = false;
    public static final String MOD_ID = "sleep_tight";
    public static final Logger LOGGER = LogManager.getLogger((String)"sleep_tight");
    public static final boolean SUPP = PlatHelper.isModLoaded((String)"supplementaries");
    public static final boolean HS = PlatHelper.isModLoaded((String)"heartstone");
    public static final boolean QUARK = PlatHelper.isModLoaded((String)"quark");
    public static final Supplier<SoundEvent> NIGHTMARE_SOUND = RegHelper.registerSound((ResourceLocation)SleepTight.res("nightmare"));
    public static final Supplier<SoundEvent> BEDBUG_AMBIENT = RegHelper.registerSound((ResourceLocation)SleepTight.res("bedbug.ambient"));
    public static final Supplier<SoundEvent> BEDBUG_DEATH = RegHelper.registerSound((ResourceLocation)SleepTight.res("bedbug.death"));
    public static final Supplier<SoundEvent> BEDBUG_HURT = RegHelper.registerSound((ResourceLocation)SleepTight.res("bedbug.hurt"));
    public static final TagKey<EntityType<?>> WAKE_UP_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)SleepTight.res("wake_up_blacklist"));
    public static final TagKey<Block> BEDBUG_WALK_THROUGH = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)SleepTight.res("bedbug_walk_through"));
    public static final TagKey<BannerPattern> MOON_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)SleepTight.res("pattern_item/moon"));
    public static final Supplier<BannerPattern> MOON_PATTERN = RegHelper.register((ResourceLocation)SleepTight.res("moon"), () -> new BannerPattern("mon"), (ResourceKey)Registries.f_256969_);
    public static final Supplier<SimpleParticleType> DREAM_PARTICLE = RegHelper.registerParticle((ResourceLocation)SleepTight.res("dream"));
    public static final Supplier<SimpleParticleType> BEDBUG_PARTICLE = RegHelper.registerParticle((ResourceLocation)SleepTight.res("bedbug"));
    public static final Supplier<MobEffect> INVIGORATED = RegHelper.registerEffect((ResourceLocation)SleepTight.res("invigorated"), () -> new InvigoratedEffect(MobEffectCategory.BENEFICIAL, 0x11FF22));
    public static final Supplier<EntityType<BedEntity>> BED_ENTITY = RegHelper.registerEntityType((ResourceLocation)SleepTight.res("bed_entity"), BedEntity::new, (MobCategory)MobCategory.MISC, (float)0.5f, (float)0.5f, (int)4, (int)Integer.MAX_VALUE);
    public static final Supplier<EntityType<BedbugEntity>> BEDBUG_ENTITY = RegHelper.registerEntityType((ResourceLocation)SleepTight.res("bedbug"), BedbugEntity::new, (MobCategory)MobCategory.MONSTER, (float)0.6875f, (float)0.375f, (int)7, (int)3);
    public static final Supplier<EntityType<DreamerEssenceTargetEntity>> DREAMER_ESSENCE_ENTITY = RegHelper.registerEntityType((ResourceLocation)SleepTight.res("dreamer_essence_dummy"), DreamerEssenceTargetEntity::new, (MobCategory)MobCategory.MISC, (float)0.2f, (float)0.75f, (int)5, (int)Integer.MAX_VALUE);
    public static final Supplier<DreamEssenceBlock> DREAMER_ESSENCE = SleepTight.regWithItem("dreamer_essence", () -> new DreamEssenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60918_(SoundType.f_154654_).m_60978_(1.0f)));
    public static final Supplier<NightBagBlock> NIGHT_BAG = SleepTight.regBlock("night_bag", () -> new NightBagBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283908_).m_60918_(SoundType.f_56745_).m_60978_(0.1f)));
    public static final Supplier<InfestedBedBlock> INFESTED_BED = SleepTight.regBlock("infested_bed", () -> new InfestedBedBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50026_)));
    public static final Map<DyeColor, Supplier<Block>> HAMMOCKS = (Map)Util.m_137537_(() -> Arrays.stream(DyeColor.values()).collect(Collectors.toUnmodifiableMap(d -> d, d -> SleepTight.regWithItem("hammock_" + d.m_41065_(), () -> new HammockBlock((DyeColor)d)))));
    public static final Supplier<BlockEntityType<HammockTile>> HAMMOCK_TILE = RegHelper.registerBlockEntityType((ResourceLocation)SleepTight.res("hammock"), () -> PlatHelper.newBlockEntityType(HammockTile::new, (Block[])((Block[])HAMMOCKS.values().stream().map(Supplier::get).toArray(Block[]::new))));
    public static final Supplier<BlockEntityType<InfestedBedTile>> INFESTED_BED_TILE = RegHelper.registerBlockEntityType((ResourceLocation)SleepTight.res("infested_bed"), () -> PlatHelper.newBlockEntityType(InfestedBedTile::new, (Block[])new Block[]{(Block)INFESTED_BED.get()}));
    public static final Supplier<BannerPatternItem> MOON_PATTERN_ITEM = SleepTight.regItem("moon_banner_pattern", () -> new BannerPatternItem(MOON_TAG, new Item.Properties().m_41487_(1)));
    public static final Supplier<NightBagItem> NIGHT_BAG_ITEM = SleepTight.regItem("night_bag", () -> new NightBagItem((Block)NIGHT_BAG.get(), new Item.Properties()));
    public static final Supplier<BedbugEggsItem> BED_BUG_EGGS = SleepTight.regItem("bedbug_eggs", () -> new BedbugEggsItem(new Item.Properties()));
    public static final Supplier<Item> BEDBUG_SPAWN_EGG = SleepTight.regItem("bedbug_spawn_egg", () -> PlatHelper.newSpawnEgg(BEDBUG_ENTITY, (int)4921363, (int)13521976, (Item.Properties)new Item.Properties()));

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        NetworkHandler.registerMessages();
        CommonConfigs.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            PackProvider.INSTANCE.register();
            ClientConfigs.init();
        }
        ModCommands.init();
        RegHelper.addAttributeRegistration(SleepTight::registerEntityAttributes);
        RegHelper.addSpawnPlacementsRegistration(SleepTight::registerSpawnPlacements);
        RegHelper.addItemsToTabsRegistration(SleepTight::registerItemsToTabs);
        EntityDataSerializers.m_135050_(BedEntity.SERIALIZER);
    }

    public static void commonSetup() {
    }

    private static void registerItemsToTabs(RegHelper.ItemToTabEvent event) {
        event.addAfter(CreativeModeTabs.f_256791_, i -> i.m_204117_(ItemTags.f_13146_), new ItemLike[]{(ItemLike)DREAMER_ESSENCE.get()});
        event.add(CreativeModeTabs.f_256869_, new ItemLike[]{(ItemLike)NIGHT_BAG.get()});
        event.add(CreativeModeTabs.f_256731_, new ItemLike[]{(ItemLike)BEDBUG_SPAWN_EGG.get()});
        event.addAfter(CreativeModeTabs.f_256968_, i -> i.m_150930_(Items.f_42591_), new ItemLike[]{(ItemLike)BED_BUG_EGGS.get()});
        event.addAfter(CreativeModeTabs.f_256968_, i -> i.m_150930_(Items.f_42725_), new ItemLike[]{(ItemLike)MOON_PATTERN_ITEM.get()});
        event.addAfter(CreativeModeTabs.f_256725_, i -> i.m_204117_(ItemTags.f_13146_), (ItemLike[])BlocksColorAPI.ordered(HAMMOCKS).map(Supplier::get).toArray(Block[]::new));
        event.addAfter(CreativeModeTabs.f_256791_, i -> i.m_150930_(Items.f_42509_), (ItemLike[])BlocksColorAPI.ordered(HAMMOCKS).map(Supplier::get).toArray(Block[]::new));
    }

    private static void registerSpawnPlacements(RegHelper.SpawnPlacementEvent event) {
        event.register(BEDBUG_ENTITY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BedbugEntity::checkMonsterSpawnRules);
    }

    private static void registerEntityAttributes(RegHelper.AttributeEvent event) {
        event.register(DREAMER_ESSENCE_ENTITY.get(), DreamerEssenceTargetEntity.makeAttributes());
        event.register(BEDBUG_ENTITY.get(), BedbugEntity.makeAttributes());
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return SleepTight.regWithItem(name, blockFactory, new Item.Properties(), 0);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties, int burnTime) {
        Supplier<T> block = SleepTight.regBlock(name, blockFactory);
        SleepTight.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static Supplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties, int burnTime) {
        return RegHelper.registerItem((ResourceLocation)SleepTight.res(name), () -> new BlockItem((Block)blockSup.get(), properties));
    }

    public static <T extends Block> Supplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)SleepTight.res(name), sup);
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)SleepTight.res(name), sup);
    }
}

