/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.diodes;

import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.content.redstone.diodes.BrassDiodeScrollSlot;
import com.simibubi.create.content.redstone.diodes.BrassDiodeScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BrassDiodeBlockEntity
extends SmartBlockEntity
implements ClipboardCloneable {
    protected int state;
    ScrollValueBehaviour maxState;

    public BrassDiodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.maxState = new BrassDiodeScrollValueBehaviour((Component)CreateLang.translateDirect("logistics.redstone_interval", new Object[0]), this, new BrassDiodeScrollSlot()).between(2, 72000);
        this.maxState.withFormatter(this::format);
        this.maxState.withCallback(this::onMaxDelayChanged);
        this.maxState.setValue(this.defaultValue());
        behaviours.add(this.maxState);
    }

    protected int defaultValue() {
        return 2;
    }

    public float getProgress() {
        int max = Math.max(2, this.maxState.getValue());
        return (float)Mth.m_14045_((int)this.state, (int)0, (int)max) / (float)max;
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public void tick() {
        super.tick();
        boolean powered = (Boolean)this.m_58900_().m_61143_((Property)DiodeBlock.f_52496_);
        boolean powering = (Boolean)this.m_58900_().m_61143_((Property)BrassDiodeBlock.POWERING);
        boolean atMax = this.state >= this.maxState.getValue();
        boolean atMin = this.state <= 0;
        this.updateState(powered, powering, atMax, atMin);
    }

    protected abstract void updateState(boolean var1, boolean var2, boolean var3, boolean var4);

    private void onMaxDelayChanged(int newMax) {
        this.state = Mth.m_14045_((int)this.state, (int)0, (int)newMax);
        this.sendData();
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.state = compound.m_128451_("State");
        super.read(compound, clientPacket);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("State", this.state);
        super.write(compound, clientPacket);
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    @Override
    public String getClipboardKey() {
        return "Block";
    }

    @Override
    public boolean readFromClipboard(CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (!tag.m_128441_("Inverted")) {
            return false;
        }
        if (simulate) {
            return true;
        }
        BlockState blockState = this.m_58900_();
        if (((Boolean)blockState.m_61143_((Property)BrassDiodeBlock.INVERTED)).booleanValue() != tag.m_128471_("Inverted")) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61122_((Property)BrassDiodeBlock.INVERTED));
        }
        return true;
    }

    @Override
    public boolean writeToClipboard(CompoundTag tag, Direction side) {
        tag.m_128379_("Inverted", this.m_58900_().m_61145_((Property)BrassDiodeBlock.INVERTED).orElse(false).booleanValue());
        return true;
    }
}

