/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.stockTicker;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public record PackageOrderWithCrafts(PackageOrder orderedStacks, List<CraftingEntry> orderedCrafts) {
    public static PackageOrderWithCrafts empty() {
        return new PackageOrderWithCrafts(PackageOrder.empty(), List.of());
    }

    public static PackageOrderWithCrafts simple(List<BigItemStack> orderedStacks) {
        return new PackageOrderWithCrafts(new PackageOrder(orderedStacks), List.of());
    }

    public static PackageOrderWithCrafts singleRecipe(List<BigItemStack> pattern) {
        return new PackageOrderWithCrafts(PackageOrder.empty(), List.of(new CraftingEntry(new PackageOrder(pattern), 1)));
    }

    public static boolean hasCraftingInformation(PackageOrderWithCrafts context) {
        if (context == null) {
            return false;
        }
        return context.orderedCrafts.size() == 1;
    }

    public List<BigItemStack> getCraftingInformation() {
        return this.orderedCrafts.get((int)0).pattern.stacks();
    }

    public List<BigItemStack> stacks() {
        return this.orderedStacks.stacks();
    }

    public boolean isEmpty() {
        return this.orderedStacks.isEmpty();
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("OrderedStacks", (Tag)this.orderedStacks.write());
        tag.m_128365_("OrderedCrafts", (Tag)NBTHelper.writeCompoundList(this.orderedCrafts, CraftingEntry::write));
        return tag;
    }

    public static PackageOrderWithCrafts read(CompoundTag tag) {
        if (tag.m_128425_("Entries", 9)) {
            return new PackageOrderWithCrafts(PackageOrder.read(tag), List.of());
        }
        return new PackageOrderWithCrafts(PackageOrder.read(tag.m_128469_("OrderedStacks")), NBTHelper.readCompoundList((ListTag)tag.m_128437_("OrderedCrafts", 10), CraftingEntry::read));
    }

    public void write(FriendlyByteBuf buffer) {
        this.orderedStacks.write(buffer);
        buffer.m_130130_(this.orderedCrafts.size());
        this.orderedCrafts.forEach(ce -> ce.write(buffer));
    }

    public static PackageOrderWithCrafts read(FriendlyByteBuf buffer) {
        PackageOrder orderedStacks = PackageOrder.read(buffer);
        ArrayList<CraftingEntry> orderedCrafts = new ArrayList<CraftingEntry>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            orderedCrafts.add(CraftingEntry.read(buffer));
        }
        return new PackageOrderWithCrafts(orderedStacks, orderedCrafts);
    }

    public boolean orderedStacksMatchOrderedRecipes() {
        if (this.orderedCrafts.isEmpty()) {
            return false;
        }
        InventorySummary stacks = new InventorySummary();
        InventorySummary crafts = new InventorySummary();
        this.stacks().forEach(stacks::add);
        this.orderedCrafts.forEach(ce -> ce.pattern.stacks().forEach(bis -> crafts.add(new BigItemStack(bis.stack, bis.count * ce.count))));
        List<BigItemStack> stackEntries = stacks.getStacks();
        if (stackEntries.size() != crafts.getStacks().size()) {
            return false;
        }
        for (BigItemStack bis : stackEntries) {
            if (crafts.getCountOf(bis.stack) == bis.count) continue;
            return false;
        }
        return true;
    }

    public record CraftingEntry(PackageOrder pattern, int count) {
        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Pattern", (Tag)this.pattern.write());
            tag.m_128405_("Count", this.count);
            return tag;
        }

        public static CraftingEntry read(CompoundTag tag) {
            return new CraftingEntry(PackageOrder.read(tag.m_128469_("Pattern")), tag.m_128451_("Count"));
        }

        public void write(FriendlyByteBuf buffer) {
            this.pattern.write(buffer);
            buffer.m_130130_(this.count);
        }

        public static CraftingEntry read(FriendlyByteBuf buffer) {
            return new CraftingEntry(PackageOrder.read(buffer), buffer.m_130242_());
        }
    }
}

