/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.registry;

import com.vicmatskiv.pointblank.Enableable;
import com.vicmatskiv.pointblank.config.ConfigManager;
import com.vicmatskiv.pointblank.config.Configurable;
import com.vicmatskiv.pointblank.entity.EntityBuilderProvider;
import com.vicmatskiv.pointblank.item.AttachmentItem;
import com.vicmatskiv.pointblank.item.ItemBuilder;
import com.vicmatskiv.pointblank.registry.AmmoRegistry;
import com.vicmatskiv.pointblank.registry.AttachmentRegistry;
import com.vicmatskiv.pointblank.registry.EntityRegistry;
import com.vicmatskiv.pointblank.registry.GunRegistry;
import com.vicmatskiv.pointblank.registry.MiscItemRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ItemRegistry {
    private Map<String, Supplier<? extends Item>> itemsByName = new LinkedHashMap<String, Supplier<? extends Item>>();
    private Map<String, List<Supplier<? extends Item>>> itemsByGroup = new LinkedHashMap<String, List<Supplier<? extends Item>>>();
    private ConfigManager.Builder gunConfigBuilder = new ConfigManager.Builder();
    private List<DeferredRegistration> deferredRegistrations = new ArrayList<DeferredRegistration>();
    public static final ItemRegistry ITEMS = new ItemRegistry();
    public static final DeferredRegister<Item> itemRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pointblank");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"pointblank");
    public static final Supplier<CreativeModeTab> POINTBLANK_TAB;

    public Map<String, Supplier<? extends Item>> getItemsByName() {
        return Collections.unmodifiableMap(this.itemsByName);
    }

    public List<Supplier<? extends Item>> getAttachmentsForGroup(String group) {
        List<Supplier<? extends Item>> groupAttachments = this.itemsByGroup.get(group);
        return groupAttachments != null ? Collections.unmodifiableList(groupAttachments) : Collections.emptyList();
    }

    public <I extends Item, T extends ItemBuilder<T>> Supplier<I> register(ItemBuilder<?> itemBuilder) {
        EntityBuilderProvider entityBuilderProvider;
        String name = itemBuilder.getName();
        if (itemBuilder instanceof Configurable) {
            Configurable configurable = (Configurable)((Object)itemBuilder);
            configurable.configure(this.gunConfigBuilder);
        }
        DeferredRegistration ro = new DeferredRegistration(itemBuilder);
        this.deferredRegistrations.add(ro);
        this.itemsByName.put(name, ro::get);
        if (itemBuilder instanceof AttachmentItem.Builder) {
            AttachmentItem.Builder attachmentBuilder = (AttachmentItem.Builder)itemBuilder;
            for (String group : attachmentBuilder.getGroups()) {
                List groupMembers = this.itemsByGroup.computeIfAbsent(group, g -> new ArrayList());
                groupMembers.add(ro::get);
            }
        }
        if ((entityBuilderProvider = itemBuilder.getEntityBuilderProvider()) != null) {
            EntityRegistry.registerItemEntity(name, () -> entityBuilderProvider.getEntityBuilder());
        }
        return () -> ro.get();
    }

    public <I extends Item> Supplier<I> getDeferredRegisteredObject(String name) {
        String normalizedName = name;
        return () -> {
            Supplier<? extends Item> registryObject = this.itemsByName.get(normalizedName);
            return registryObject != null ? registryObject.get() : null;
        };
    }

    public void register(IEventBus modEventBus) {
        itemRegistry.register(modEventBus);
    }

    public void syncEnabledItems(List<Integer> itemIds) {
    }

    public void complete() {
        this.gunConfigBuilder.build();
        Iterator<DeferredRegistration> it = this.deferredRegistrations.iterator();
        while (it.hasNext()) {
            Enableable e;
            DeferredRegistration dr = it.next();
            ItemBuilder<?> itemBuilder = dr.itemBuilder;
            if (itemBuilder instanceof Enableable && !(e = (Enableable)((Object)itemBuilder)).isEnabled()) {
                it.remove();
                dr.resolve(false);
                continue;
            }
            dr.resolve(true);
        }
    }

    static {
        MiscItemRegistry.init();
        AmmoRegistry.init();
        AttachmentRegistry.init();
        GunRegistry.init();
        POINTBLANK_TAB = TABS.register("pointblank", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.pointblank.items")).m_257737_(() -> new ItemStack((ItemLike)(GunRegistry.M4A1.get() != null ? (ItemLike)GunRegistry.M4A1.get() : Items.f_41852_))).m_257501_((enabledFeatures, entries) -> {
            Consumer<ItemLike> output = new Consumer<ItemLike>(){

                @Override
                public void accept(ItemLike itemLike) {
                    Enableable e;
                    if (itemLike != null && itemLike != Items.f_41852_ && (!(itemLike instanceof Enableable) || (e = (Enableable)itemLike).isEnabled())) {
                        entries.m_246326_(itemLike);
                    }
                }
            };
            GunRegistry.registerTabItems(output);
            AttachmentRegistry.registerTabItems(output);
            AmmoRegistry.registerTabItems(output);
            MiscItemRegistry.registerTabItems(output);
        }).m_257652_());
    }

    private class DeferredRegistration {
        private Supplier<Item> supplier;
        private ItemBuilder<?> itemBuilder;

        DeferredRegistration(ItemBuilder<?> itemBuilder) {
            this.itemBuilder = itemBuilder;
        }

        void resolve(boolean register) {
            String name = this.itemBuilder.getName();
            if (register) {
                RegistryObject ro = itemRegistry.register(name, () -> this.itemBuilder.build());
                this.supplier = () -> (Item)ro.orElse(null);
            } else {
                this.supplier = () -> null;
            }
        }

        public Item get() {
            return this.supplier.get();
        }
    }
}

