/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.vicmatskiv.pointblank.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface PointBlankIngredient {
    public List<ItemStack> getItemStacks();

    public JsonElement toJson();

    public int getCount();

    default public boolean matches(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.getItemStacks().stream().anyMatch(ingredientStack -> ingredientStack.m_150930_(itemStack.m_41720_()));
    }

    public void toNetwork(FriendlyByteBuf var1);

    public static PointBlankIngredient of(TagKey<Item> tagKey, int count) {
        return new TagIngredient(tagKey, count);
    }

    public static PointBlankIngredient of(ItemLike itemLike, int count) {
        return new ItemIngredient(new ItemStack(itemLike, count));
    }

    public static PointBlankIngredient fromNetwork(FriendlyByteBuf byteBuf) {
        boolean isItem = byteBuf.readBoolean();
        if (isItem) {
            return ItemIngredient.fromNetwork(byteBuf);
        }
        return TagIngredient.fromNetwork(byteBuf);
    }

    public static PointBlankIngredient fromJson(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull() || !jsonElement.isJsonObject()) {
            throw new JsonSyntaxException("Invalid json ingredient element: " + jsonElement);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("item") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (jsonObject.has("item")) {
            return ItemIngredient.fromJson(jsonObject);
        }
        if (jsonObject.has("tag")) {
            return TagIngredient.fromJson(jsonObject);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static class TagIngredient
    implements PointBlankIngredient {
        private TagKey<Item> tagKey;
        private int count;
        private List<ItemStack> itemStacks;

        private TagIngredient(TagKey<Item> tagKey, int count) {
            this.tagKey = tagKey;
            this.count = count;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public List<ItemStack> getItemStacks() {
            if (this.itemStacks == null) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(this.tagKey)) {
                    itemStacks.add(new ItemStack((ItemLike)holder.m_203334_(), this.count));
                }
                this.itemStacks = Collections.unmodifiableList(itemStacks);
            }
            return this.itemStacks;
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tagKey.f_203868_().toString());
            jsonObject.addProperty("count", (Number)this.count);
            return jsonObject;
        }

        public static PointBlankIngredient fromJson(JsonObject jsonObject) {
            String tagResourceLocation = JsonUtil.getJsonString(jsonObject, "tag", null);
            if (tagResourceLocation == null) {
                throw new JsonSyntaxException("Missing ingredient tag");
            }
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagResourceLocation));
            int count = JsonUtil.getJsonInt(jsonObject, "count", 1);
            return new TagIngredient((TagKey<Item>)tagKey, count);
        }

        @Override
        public final void toNetwork(FriendlyByteBuf byteBuf) {
            byteBuf.writeBoolean(false);
            byteBuf.m_130085_(this.tagKey.f_203868_());
            byteBuf.writeInt(this.count);
        }

        public static PointBlankIngredient fromNetwork(FriendlyByteBuf byteBuf) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)byteBuf.m_130281_());
            int count = byteBuf.readInt();
            return new TagIngredient((TagKey<Item>)tagKey, count);
        }
    }

    public static class ItemIngredient
    implements PointBlankIngredient {
        private ItemStack itemStack;

        public ItemIngredient(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        @Override
        public int getCount() {
            return this.itemStack.m_41613_();
        }

        @Override
        public List<ItemStack> getItemStacks() {
            return Collections.singletonList(this.itemStack);
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.itemStack.m_41720_()).toString());
            jsonObject.addProperty("count", (Number)this.itemStack.m_41613_());
            return jsonObject;
        }

        public static PointBlankIngredient fromJson(JsonObject jsonObject) {
            String itemLocation = JsonUtil.getJsonString(jsonObject, "item", null);
            if (itemLocation == null) {
                throw new JsonSyntaxException("Missing ingredient tag");
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemLocation));
            int count = JsonUtil.getJsonInt(jsonObject, "count", 1);
            return new ItemIngredient(new ItemStack((ItemLike)item, count));
        }

        @Override
        public final void toNetwork(FriendlyByteBuf byteBuf) {
            byteBuf.writeBoolean(true);
            byteBuf.m_130055_(this.itemStack);
        }

        public static PointBlankIngredient fromNetwork(FriendlyByteBuf byteBuf) {
            return new ItemIngredient(byteBuf.m_130267_());
        }
    }
}

