/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisCompat;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;

public class DefaultRenderTypeProvider
extends RenderStateShard
implements RenderTypeProvider {
    private static DefaultRenderTypeProvider instance;
    private static Optional<ShaderInstance> posTexColorShader;
    private static Optional<ShaderInstance> auxShader;
    private Function<Boolean, RenderType> pipRenderTypes = Util.m_143827_(isMasked -> DefaultRenderTypeProvider.createPipRenderType(isMasked));
    private Function<ResourceLocation, RenderType> pipOverlayRenderTypes = Util.m_143827_(texture -> DefaultRenderTypeProvider.createPipOverlayRenderType(texture, false));
    private Function<ResourceLocation, RenderType> pipOverlayRenderTypesMasked = Util.m_143827_(texture -> DefaultRenderTypeProvider.createPipOverlayRenderType(texture, true));
    private Function<ResourceLocation, RenderType> pipMaskRenderTypes = Util.m_143827_(texture -> DefaultRenderTypeProvider.createPipMaskRenderType(texture));
    private Function<ResourceLocation, RenderType> muzzleFlashRenderTypes = Util.m_143827_(texture -> DefaultRenderTypeProvider.createMuzzleFlashRenderType(texture));
    private Function<ResourceLocation, RenderType> reticleRenderTypes = Util.m_143827_(texture -> DefaultRenderTypeProvider.createReticleRenderType(texture));
    private Function<ResourceLocation, RenderType> reticleRenderTypesWithParallax = Util.m_143827_(texture -> DefaultRenderTypeProvider.createReticleRenderType(texture, ClientSystem.getInstance()::getTexColorShaderInstance));
    private Function<ResourceLocation, RenderType> glowEntityRenderTypes = Util.m_143827_(texture -> GlowEntityRenderType.createRenderType(texture));
    private static final PipTextureStateShard PIP_TEXTURE_STATE_SHARD;

    public static DefaultRenderTypeProvider getInstance() {
        if (instance == null) {
            instance = new DefaultRenderTypeProvider();
        }
        return instance;
    }

    public DefaultRenderTypeProvider() {
        super(null, null, null);
    }

    @Override
    public RenderType getPipRenderType(boolean isMasked) {
        return this.pipRenderTypes.apply(isMasked);
    }

    @Override
    public RenderType getPipOverlayRenderType(ResourceLocation texture, boolean isMasked) {
        return isMasked ? this.pipOverlayRenderTypesMasked.apply(texture) : this.pipOverlayRenderTypes.apply(texture);
    }

    @Override
    public RenderType getPipMaskRenderType(ResourceLocation texture) {
        return this.pipMaskRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowRenderType(ResourceLocation texture) {
        return RenderType.m_234335_((ResourceLocation)texture, (boolean)true);
    }

    @Override
    public RenderType getMuzzleFlashRenderType(ResourceLocation texture) {
        return this.muzzleFlashRenderTypes.apply(texture);
    }

    @Override
    public RenderType getReticleRenderType(ResourceLocation texture, boolean isParallaxEnabled) {
        return isParallaxEnabled ? this.reticleRenderTypesWithParallax.apply(texture) : this.reticleRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowBlockEntityRenderType(ResourceLocation texture) {
        if (IrisCompat.getInstance().isIrisLoaded()) {
            return RenderType.m_110473_((ResourceLocation)texture);
        }
        return this.glowEntityRenderTypes.apply(texture);
    }

    private static ShaderInstance getPosTexColorShader() {
        if (posTexColorShader != null) {
            return posTexColorShader.orElse(null);
        }
        String shaderName = "pointblank_position_tex_color";
        try {
            Minecraft mc = Minecraft.m_91087_();
            posTexColorShader = Optional.of(new ShaderInstance((ResourceProvider)mc.m_91098_(), shaderName, DefaultVertexFormat.f_85819_));
        }
        catch (Exception e) {
            e.printStackTrace();
            posTexColorShader = Optional.empty();
        }
        return posTexColorShader.get();
    }

    private static ShaderInstance getAuxShader() {
        if (auxShader != null) {
            return auxShader.orElse(null);
        }
        String shaderName = "pointblank_aux";
        try {
            Minecraft mc = Minecraft.m_91087_();
            auxShader = Optional.of(new ShaderInstance((ResourceProvider)mc.m_91098_(), shaderName, DefaultVertexFormat.f_85819_));
        }
        catch (Exception e) {
            e.printStackTrace();
            auxShader = Optional.empty();
        }
        return auxShader.get();
    }

    private static RenderType createPipRenderType(boolean isMasked) {
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.m_173215_((String)"pointblank:pip", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(DefaultRenderTypeProvider::getAuxShader)).m_173290_((RenderStateShard.EmptyTextureStateShard)PIP_TEXTURE_STATE_SHARD).m_110685_(f_110134_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_110661_(f_110110_).m_110691_(true)), setup, clear);
    }

    private static RenderType createPipMaskRenderType(ResourceLocation maskTexture) {
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.CompositeRenderType.m_173215_((String)"pointblank:pip_mask", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110134_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(maskTexture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172820_)).m_110691_(false)), RenderTypeProvider.SETUP_STENCIL_MASK_RENDER, RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER);
    }

    private static RenderType createPipOverlayRenderType(ResourceLocation overlayTexture, boolean isMasked) {
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_overlay_" + isMasked), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(overlayTexture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(DefaultRenderTypeProvider::getPosTexColorShader)).m_110691_(false)), setup, clear);
    }

    private static RenderType createMuzzleFlashRenderType(ResourceLocation texture) {
        return RenderType.m_173215_((String)"pointblank:muzzle_flash", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110136_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientSystem.getInstance()::getColorTexLightmapShaderInstance)).m_110691_(false));
    }

    private static RenderType createReticleRenderType(ResourceLocation texture, Supplier<ShaderInstance> shaderSupplier) {
        return RenderType.m_173215_((String)"pointblank:reticle_parallax", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).m_110691_(false));
    }

    private static RenderType createReticleRenderType(ResourceLocation reticleResource) {
        return RenderType.m_173215_((String)"pointblank:reticle", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(reticleResource, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientSystem.getInstance()::getColorTexLightmapShaderInstance)).m_110691_(false));
    }

    static {
        PIP_TEXTURE_STATE_SHARD = new PipTextureStateShard();
    }

    private static class PipTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        public PipTextureStateShard() {
            super(() -> {
                int textureId = ClientSystem.getInstance().getAuxLevelRenderer().getRenderTarget().m_83975_();
                RenderSystem.setShaderTexture((int)0, (int)textureId);
            }, () -> {});
        }
    }

    private static final class GlowEntityRenderType
    extends RenderType {
        public GlowEntityRenderType(String renderTypeName, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(renderTypeName, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        private static RenderType createRenderType(ResourceLocation texture) {
            return RenderType.m_173215_((String)"pointblank:glowy_entity_block", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110136_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(RenderStateShard.f_173101_).m_110691_(false));
        }
    }
}

