/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client;

import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.controller.BlendingAnimationController;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.StateMachine;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.ClientUtils;

public class FirstPersonWalkingAnimationHandler {
    public static final String WALKING_CONTROLLER_NAME = "walking";
    private static final float MIN_SPEED_SQUARED = 1.0E-4f;
    private final StateMachine<PlayerWalkingState, PlayerWalkingStateContext> firstPersonAnimationStateMachine = this.createFirstPersonAnimationStateMachine();
    private long ts;

    private StateMachine<PlayerWalkingState, PlayerWalkingStateContext> createFirstPersonAnimationStateMachine() {
        StateMachine.Builder<PlayerWalkingState, PlayerWalkingStateContext> builder = new StateMachine.Builder<PlayerWalkingState, PlayerWalkingStateContext>();
        Minecraft mc = Minecraft.m_91087_();
        builder.withTransition(PlayerWalkingState.NONE, PlayerWalkingState.STANDING, ctx -> mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON && !ctx.state.isDrawing() && System.currentTimeMillis() - this.ts > 100L, StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT, PlayerWalkingState.RUNNING, PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.OFF_GROUND, PlayerWalkingState.OFF_GROUND_SPRINTING)), PlayerWalkingState.NONE, ctx -> mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON, StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.OFF_GROUND, ctx -> !ctx.player.m_20096_() && !ctx.player.m_20142_(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.OFF_GROUND, ctx -> ctx.speedSquared > 1.0E-4f && !ctx.player.m_20096_() && (!ctx.player.m_20142_() || ctx.player.m_108635_()) && ctx.isMovingForward() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.RUNNING)), PlayerWalkingState.OFF_GROUND_SPRINTING, ctx -> !ctx.player.m_20096_() && ctx.player.m_20142_(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.OFF_GROUND_SPRINTING, ctx -> ctx.player.m_20142_() && !ctx.player.m_20096_() && !ctx.player.m_108635_() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_PREPARE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING_AIMING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && !ctx.player.m_20142_() && ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_AIMING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && !ctx.player.m_20142_() && ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && !ctx.player.m_20142_() && ctx.isMovingForward() && !ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && (!ctx.player.m_20142_() || ctx.player.m_108635_()) && ctx.isMovingForward() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING_BACKWARDS, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && (!ctx.player.m_20142_() || ctx.player.m_108635_()) && ctx.isMovingBackward() && !ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_BACKWARDS, ctx -> ctx.speedSquared > 1.0E-4f && (!ctx.player.m_20142_() || ctx.player.m_108635_()) && ctx.isMovingBackward() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING_LEFT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && (!ctx.player.m_20142_() || ctx.player.m_108635_()) && ctx.isMovingLeft() && !ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_LEFT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && (!ctx.player.m_20142_() || ctx.player.m_108635_()) && ctx.isMovingLeft() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT)), PlayerWalkingState.WALKING_RIGHT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && !ctx.player.m_20142_() && !ctx.state.isAiming() && ctx.isMovingRight(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_RIGHT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.m_20096_() && (!ctx.player.m_20142_() || ctx.player.m_108635_()) && ctx.isMovingRight() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.STANDING, ctx -> ctx.player.m_20096_() && !ctx.player.m_20142_() && ctx.speedSquared <= 1.0E-4f, StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.STANDING, ctx -> ctx.player.m_20096_() && !ctx.player.m_20142_() && ctx.speedSquared <= 1.0E-4f && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT, PlayerWalkingState.COMPLETE_RUNNING)), PlayerWalkingState.PREPARE_RUNNING, ctx -> ctx.player.m_20142_() && !ctx.player.m_108635_() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation("animation.model.fire", ctx.itemStack, "fire_controller"), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND_SPRINTING)), PlayerWalkingState.RUNNING, ctx -> ctx.player.m_20096_(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.RUNNING, ctx -> ctx.player.m_20142_() && ctx.player.m_20096_() && !ctx.player.m_108635_() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_PREPARE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.RUNNING, PlayerWalkingState.OFF_GROUND_SPRINTING)), PlayerWalkingState.COMPLETE_RUNNING, ctx -> !ctx.player.m_20142_() || ctx.player.m_108635_(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withOnChangeStateAction((ctx, f, t) -> {
            long id = GeoItem.getId((ItemStack)ctx.itemStack);
            GunItem gunItem = (GunItem)ctx.itemStack.m_41720_();
            switch (t) {
                case STANDING: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.standing");
                    break;
                }
                case WALKING_AIMING: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_aiming");
                    break;
                }
                case WALKING: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking");
                    break;
                }
                case WALKING_BACKWARDS: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_backwards");
                    break;
                }
                case WALKING_LEFT: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_left");
                    break;
                }
                case WALKING_RIGHT: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_right");
                    break;
                }
                case PREPARE_RUNNING: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.runningstart");
                    break;
                }
                case RUNNING: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.running");
                    break;
                }
                case COMPLETE_RUNNING: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.runningend");
                    break;
                }
                case OFF_GROUND: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.off_ground");
                    break;
                }
                case OFF_GROUND_SPRINTING: {
                    gunItem.triggerAnim((Entity)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.off_ground_sprinting");
                    break;
                }
                case NONE: {
                    AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(WALKING_CONTROLLER_NAME, ctx.itemStack);
                    controller.forceAnimationReset();
                    controller.setAnimation(null);
                    ((BlendingAnimationController)controller).clearAll();
                }
            }
        });
        return builder.build(PlayerWalkingState.STANDING);
    }

    public void handlePlayerFirstPersonMovement(Player player, ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Player mainPlayer = ClientUtils.getClientPlayer();
        if (player != mainPlayer) {
            return;
        }
        PlayerWalkingStateContext context = new PlayerWalkingStateContext((LocalPlayer)player, itemStack);
        if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            this.firstPersonAnimationStateMachine.update(context);
        } else {
            this.firstPersonAnimationStateMachine.update(context);
        }
    }

    public void reset(Player player, ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return;
        }
        this.ts = System.currentTimeMillis();
        this.firstPersonAnimationStateMachine.resetToState(PlayerWalkingState.NONE);
    }

    public static boolean isPlayingAnimation(RawAnimation rawAnimation, ItemStack itemStack) {
        BlendingAnimationController bac;
        Item item = itemStack.m_41720_();
        if (!(item instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)item;
        AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(WALKING_CONTROLLER_NAME, itemStack);
        return (rawAnimation == controller.getCurrentRawAnimation() || controller instanceof BlendingAnimationController && (bac = (BlendingAnimationController)controller).getTriggeredAnimation() == rawAnimation) && controller.getAnimationState() != AnimationController.State.STOPPED;
    }

    public static boolean isPlayingBlendingAnimation(Collection<RawAnimation> rawAnimations, ItemStack itemStack, double minProgress, double maxProgress) {
        boolean result;
        Item item = itemStack.m_41720_();
        if (!(item instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)item;
        AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(WALKING_CONTROLLER_NAME, itemStack);
        if (!(controller instanceof BlendingAnimationController)) {
            return false;
        }
        BlendingAnimationController bac = (BlendingAnimationController)controller;
        boolean bl = result = FirstPersonWalkingAnimationHandler.collectionContains(rawAnimations, bac.getTriggeredAnimation()) && bac.getAnimationState() != AnimationController.State.STOPPED;
        if (!result) {
            return false;
        }
        double progress = bac.getAnimationProgress();
        return minProgress <= progress && progress < maxProgress;
    }

    private static <T> boolean collectionContains(Collection<T> items, T item) {
        return item != null && items.contains(item);
    }

    public static boolean isPlayingAnimation(String animationName, ItemStack itemStack, String controllerName) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)item;
        AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(controllerName, itemStack);
        AnimationProcessor.QueuedAnimation currentAnimation = controller.getCurrentAnimation();
        return currentAnimation != null && animationName.equals(currentAnimation.animation().name()) && controller.getAnimationState() != AnimationController.State.STOPPED;
    }

    private static enum PlayerWalkingState {
        NONE,
        OFF_GROUND,
        OFF_GROUND_SPRINTING,
        STANDING,
        WALKING,
        WALKING_BACKWARDS,
        WALKING_LEFT,
        WALKING_RIGHT,
        WALKING_AIMING,
        PREPARE_RUNNING,
        RUNNING,
        COMPLETE_RUNNING;

    }

    private static class PlayerWalkingStateContext {
        final LocalPlayer player;
        final ItemStack itemStack;
        final float speedSquared;
        final GunClientState state;

        public PlayerWalkingStateContext(LocalPlayer player, ItemStack itemStack) {
            this.player = player;
            this.itemStack = itemStack;
            this.speedSquared = player.f_108618_.m_108575_().m_165912_();
            this.state = GunClientState.getMainHeldState();
        }

        boolean isMovingForward() {
            return this.player.f_108618_.f_108568_;
        }

        boolean isMovingBackward() {
            return this.player.f_108618_.f_108569_;
        }

        boolean isMovingLeft() {
            return this.player.f_108618_.f_108570_ && !this.player.f_108618_.f_108568_ && !this.player.f_108618_.f_108569_;
        }

        boolean isMovingRight() {
            return this.player.f_108618_.f_108571_ && !this.player.f_108618_.f_108568_ && !this.player.f_108618_.f_108569_;
        }
    }
}

