/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank;

import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.client.effect.EffectLauncher;
import com.vicmatskiv.pointblank.crafting.PointBlankRecipeProvider;
import com.vicmatskiv.pointblank.entity.ItemsAndEmeraldsToItems;
import com.vicmatskiv.pointblank.event.AttachmentRemovedEvent;
import com.vicmatskiv.pointblank.item.AmmoItem;
import com.vicmatskiv.pointblank.item.FireModeInstance;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.ThrowableItem;
import com.vicmatskiv.pointblank.network.ClientBoundPlayerDataSyncPacket;
import com.vicmatskiv.pointblank.network.Network;
import com.vicmatskiv.pointblank.registry.AmmoRegistry;
import com.vicmatskiv.pointblank.registry.BlockEntityRegistry;
import com.vicmatskiv.pointblank.registry.BlockRegistry;
import com.vicmatskiv.pointblank.registry.EffectRegistry;
import com.vicmatskiv.pointblank.registry.EntityRegistry;
import com.vicmatskiv.pointblank.registry.ExtensionRegistry;
import com.vicmatskiv.pointblank.registry.FeatureTypeRegistry;
import com.vicmatskiv.pointblank.registry.ItemRegistry;
import com.vicmatskiv.pointblank.registry.MenuRegistry;
import com.vicmatskiv.pointblank.registry.MiscItemRegistry;
import com.vicmatskiv.pointblank.registry.ParticleRegistry;
import com.vicmatskiv.pointblank.registry.RecipeTypeRegistry;
import com.vicmatskiv.pointblank.registry.SoundRegistry;
import com.vicmatskiv.pointblank.registry.VillagerRegistry;
import com.vicmatskiv.pointblank.util.InventoryUtils;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.ServerTaskScheduler;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import com.vicmatskiv.pointblank.util.Tradeable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingSwapItemsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="pointblank")
public class PointBlankMod {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private ExtensionRegistry extensionRegistry;
    private static ServerTaskScheduler scheduler = new ServerTaskScheduler();
    private Random random = new Random();

    public PointBlankMod() {
        LOGGER.info("Loading mod {}", (Object)"pointblank");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        GeckoLib.initialize();
        FeatureTypeRegistry.init();
        this.extensionRegistry = new ExtensionRegistry();
        Dist side = FMLLoader.getDist();
        this.extensionRegistry.discoverExtensions(side.isClient() ? PackType.CLIENT_RESOURCES : PackType.SERVER_DATA);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExtensionRegistry.registerItemsFromExtensions(this.extensionRegistry, modEventBus);
        ParticleRegistry.PARTICLES.register(modEventBus);
        SoundRegistry.SOUNDS.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ItemRegistry.TABS.register(modEventBus);
        BlockEntityRegistry.BLOCK_ENTITY_TYPES.register(modEventBus);
        BlockRegistry.BLOCKS.register(modEventBus);
        VillagerRegistry.POI_TYPES.register(modEventBus);
        VillagerRegistry.PROFESSIONS.register(modEventBus);
        EntityRegistry.ENTITIES.register(modEventBus);
        MenuRegistry.MENU_TYPES.register(modEventBus);
        RecipeTypeRegistry.RECIPE_TYPES.register(modEventBus);
        RecipeTypeRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        ItemRegistry.ITEMS.complete();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::onAddPackFinder);
        modEventBus.addListener(this::onGatherData);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Network.setupNetworkChannel();
    }

    public static ServerTaskScheduler getServerTaskScheduler() {
        return scheduler;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new PointBlankRecipeProvider(output));
    }

    @SubscribeEvent
    public void onSwapHands(LivingSwapItemsEvent.Hands event) {
        ItemStack toOffhand = event.getItemSwappedToOffHand();
        if (toOffhand != null && (toOffhand.m_41720_() instanceof GunItem || toOffhand.m_41720_() instanceof ThrowableItem)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start explosionStart) {
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        server.m_129946_((Runnable)scheduler);
    }

    @SubscribeEvent
    public void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        VillagerRegistry.registerStructures(event.getServer());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    private void onAddPackFinder(AddPackFindersEvent event) {
        event.addRepositorySource(this.extensionRegistry.getRepositorySource());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
    }

    @SubscribeEvent
    public void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == VillagerRegistry.ARMS_DEALER_PROFESSION.get()) {
            for (Map.Entry<String, Supplier<? extends Item>> e : ItemRegistry.ITEMS.getItemsByName().entrySet()) {
                int emeraldCount;
                List levelTrades;
                Item item = e.getValue().get();
                if (!(item instanceof Tradeable)) continue;
                Tradeable tradeableItem = (Tradeable)item;
                float price = tradeableItem.getPrice();
                int tradeLevel = tradeableItem.getTradeLevel();
                if (Float.isNaN(price) || tradeLevel < 1 || tradeLevel > 5 || (levelTrades = (List)event.getTrades().get(tradeLevel)) == null || (emeraldCount = (int)Math.round((double)price / Config.emeraldExchangeRate)) <= 0) continue;
                ItemsAndEmeraldsToItems trade = new ItemsAndEmeraldsToItems((ItemLike)Items.f_42616_, emeraldCount, item, tradeableItem.getBundleQuantity(), 16, 1);
                levelTrades.add(trade);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        float dropChance = (float)Config.itemDropChance;
        if (MiscUtil.isNearlyZero(dropChance)) {
            return;
        }
        float randomNumber = this.random.nextFloat();
        if (event.getEntity() instanceof Monster && randomNumber < dropChance) {
            ItemStack itemStackToDrop = new ItemStack((ItemLike)MiscItemRegistry.GUNMETAL_NUGGET.get(), this.random.nextInt(1, Config.maxItemDropCount));
            ItemEntity drop = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), itemStackToDrop);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack itemStack = event.player.m_21205_();
        if (itemStack != null && itemStack.m_41720_() instanceof GunItem && GunItem.isAiming(itemStack)) {
            event.player.m_6858_(false);
        }
    }

    @SubscribeEvent
    public void onHarvestCheck(PlayerEvent.HarvestCheck check) {
        Player player;
        ItemStack heldItem;
        if (check.getTargetBlock().m_60713_((Block)BlockRegistry.PRINTER.get()) && (heldItem = (player = check.getEntity()).m_21205_()) != null && heldItem.m_41720_() instanceof PickaxeItem) {
            check.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if (event.getTo() != null && (event.getTo().m_41720_() instanceof GunItem || event.getTo().m_41720_() instanceof ThrowableItem) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.OFFHAND) {
                ItemStack copy = event.getTo().m_41777_();
                player.m_150109_().f_35976_.clear();
                Vec3 playerPos = event.getEntity().m_20318_(0.0f);
                Containers.m_18992_((Level)MiscUtil.getLevel((Entity)event.getEntity()), (double)playerPos.f_82479_, (double)playerPos.f_82480_, (double)playerPos.f_82481_, (ItemStack)copy);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.f_46443_) {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundPlayerDataSyncPacket(player.getPersistentData(), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)v.get()))).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.f_46443_) {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundPlayerDataSyncPacket(player.getPersistentData(), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)v.get()))).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.f_46443_) {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundPlayerDataSyncPacket(player.getPersistentData(), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)v.get()))).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public void onAttachmentRemoved(AttachmentRemovedEvent event) {
        ItemStack rootStack = event.getRootStack();
        Item item = rootStack.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Player player = event.getPlayer();
        if (player == null || MiscUtil.isClientSide((Entity)player)) {
            return;
        }
        List<FireModeInstance> fireModeInstances = gunItem.getMainFireModes();
        for (FireModeInstance fireModeInstance : fireModeInstances) {
            int dropCount;
            int maxAmmoCapacity;
            int currentFireModeAmmo = GunItem.getAmmo(rootStack, fireModeInstance);
            int delta = Math.min(currentFireModeAmmo - (maxAmmoCapacity = gunItem.getMaxAmmoCapacity(rootStack, fireModeInstance)), 1728);
            if (delta <= 0) continue;
            List<AmmoItem> actualAmmo = fireModeInstance.getActualAmmo();
            AmmoItem ammoToRemove = null;
            if (actualAmmo.size() == 1) {
                ammoToRemove = actualAmmo.get(0);
            } else if (actualAmmo.size() > 1) {
                AmmoItem creativeAmmo = AmmoRegistry.AMMOCREATIVE.get();
                ammoToRemove = actualAmmo.contains(creativeAmmo) && player.m_7500_() ? creativeAmmo : (AmmoItem)actualAmmo.stream().filter(a -> a != creativeAmmo).findAny().orElse(null);
            }
            if (ammoToRemove == null) continue;
            GunItem.setAmmo(rootStack, fireModeInstance, maxAmmoCapacity);
            for (int remainingCount = InventoryUtils.addItem(player, ammoToRemove, delta); remainingCount > 0; remainingCount -= dropCount) {
                dropCount = Math.min(ammoToRemove.m_41459_(), remainingCount);
                Containers.m_18992_((Level)MiscUtil.getLevel((Entity)event.getPlayer()), (double)(player.m_20185_() + 1.25), (double)(player.m_20186_() + 1.25), (double)player.m_20189_(), (ItemStack)new ItemStack((ItemLike)ammoToRemove, dropCount));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        DamageSource damageSource = event.getSource();
        if (damageSource != null && (entity = damageSource.m_7639_()) instanceof Player) {
            GunClientState state;
            Player player = (Player)entity;
            if (!MiscUtil.getLevel((Entity)player).f_46443_ && (state = GunClientState.getMainHeldState(player)) != null) {
                LivingEntity targetEntity = event.getEntity();
                List<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>> effects = EffectRegistry.getEntityDeathEffects(targetEntity);
                for (Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> supplier : effects) {
                    Vec3 targetPos = targetEntity.m_20191_().m_82399_();
                    EffectLauncher.broadcast(supplier, player, state, targetEntity, new SimpleHitResult(targetPos, HitResult.Type.ENTITY, Direction.DOWN, targetEntity.m_19879_()));
                }
            }
        }
    }
}

