/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hat;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class DrinkingHatItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"drinking").stat(StatData.builder((String)"speed").initialValue(0.3, 0.35).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.045).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)0)).build()).build()).ability(AbilityData.builder((String)"nutrition").requiredLevel(5).stat(StatData.builder((String)"hunger").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 15, 100)).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    @Mod.EventBusSubscriber
    public static class DrinkingHatEvents {
        @SubscribeEvent
        public static void onUseItemStart(LivingEntityUseItemEvent.Start event) {
            DrinkingHatItem relic;
            ItemStack stack;
            block6: {
                block5: {
                    Item item;
                    Player player;
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20193_().m_5776_()) {
                        return;
                    }
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.PLASTIC_DRINKING_HAT.get()));
                    if (stack.m_41619_()) {
                        stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.NOVELTY_DRINKING_HAT.get()));
                    }
                    if (!((item = stack.m_41720_()) instanceof DrinkingHatItem)) break block5;
                    relic = (DrinkingHatItem)item;
                    if (event.getItem().m_41780_() == UseAnim.DRINK) break block6;
                }
                return;
            }
            event.setDuration((int)((double)event.getDuration() * (1.0 - relic.getAbilityValue(stack, "drinking", "speed"))));
        }

        @SubscribeEvent
        public static void onUseItem(LivingEntityUseItemEvent.Finish event) {
            DrinkingHatItem relic;
            ItemStack stack;
            Player player;
            block7: {
                block6: {
                    Item item;
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20193_().m_5776_()) {
                        return;
                    }
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.PLASTIC_DRINKING_HAT.get()));
                    if (stack.m_41619_()) {
                        stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.NOVELTY_DRINKING_HAT.get()));
                    }
                    if (!((item = stack.m_41720_()) instanceof DrinkingHatItem)) break block6;
                    relic = (DrinkingHatItem)item;
                    if (event.getItem().m_41780_() == UseAnim.DRINK) break block7;
                }
                return;
            }
            relic.addExperience((LivingEntity)player, stack, (int)Math.ceil((float)event.getDuration() / 20.0f));
            if (!relic.canUseAbility(stack, "nutrition")) {
                return;
            }
            int hunger = (int)relic.getAbilityValue(stack, "nutrition", "hunger");
            player.m_36324_().m_38707_(hunger, (float)hunger / 2.0f);
        }
    }
}

