/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.content.block.IHeavyDoor;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.content.block.LeadDoorBlock;
import galena.oreganized.index.OBlockEntities;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.ODamageSources;
import galena.oreganized.world.IDoorProgressHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class HeavyDoorBlockEntity
extends BlockEntity {
    private int pressure = 0;
    private final BlockSetType set = OBlocks.LEAD_BLOCK_SET;
    private static final int REQUIRED_PRESSURE_OPEN = 20;

    public HeavyDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OBlockEntities.HEAVY_DOOR.get(), pos, state);
    }

    public static Optional<HeavyDoorBlockEntity> getAt(LevelAccessor level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof HeavyDoorBlockEntity) {
            HeavyDoorBlockEntity door = (HeavyDoorBlockEntity)be;
            return Optional.of(door);
        }
        return Optional.empty();
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == OBlockEntities.HEAVY_DOOR.get()) {
            BlockEntityTicker ticker = (l, p, s, be) -> be.tick(s, l, p);
            return ticker;
        }
        return null;
    }

    public void tick(BlockState state, Level level, BlockPos pos) {
        if (this.pressure <= 0) {
            return;
        }
        --this.pressure;
        if (this.pressure == 0) {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false));
                level.m_7731_(pos, state, 10);
                level.m_220407_(GameEvent.f_157793_, pos, GameEvent.Context.m_223722_((BlockState)state));
                Block block = state.m_60734_();
                if (block instanceof IHeavyDoor) {
                    IHeavyDoor heavy = (IHeavyDoor)block;
                    heavy.sound(null, level, pos, false);
                }
            }
            this.stopUsing(state, level, pos, null);
        } else if (this.pressure < 15) {
            this.setAnimationState(level, pos, state, true);
        }
    }

    private void setAnimationState(Level level, BlockPos pos, BlockState state, boolean animationState) {
        if (state.m_61138_((Property)LeadDoorBlock.ANIMATED) && (Boolean)state.m_61143_((Property)LeadDoorBlock.ANIMATED) != animationState) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LeadDoorBlock.ANIMATED, (Comparable)Boolean.valueOf(animationState)));
        }
    }

    private void stopUsing(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        this.setAnimationState(level, pos, state, false);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Pressure", this.pressure);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("Pressure", 99)) {
            this.pressure = nbt.m_128451_("Pressure");
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player) {
        IDoorProgressHolder progressHolder = (IDoorProgressHolder)player;
        progressHolder.oreganised$incrementOpeningProgress();
        Block block = state.m_60734_();
        if (block instanceof IMeltableBlock) {
            IMeltableBlock meltable = (IMeltableBlock)block;
            int goopyness = meltable.getGoopyness(state);
            if (goopyness > 0) {
                player.m_6469_(level.m_269111_().m_269079_(ODamageSources.MOLTEN_LEAD), 1.0f);
            }
            if (goopyness > 1) {
                return InteractionResult.FAIL;
            }
        }
        if (this.pressure == 0) {
            this.setAnimationState(level, pos, state, true);
        }
        if (!level.f_46443_) {
            System.out.println(this.pressure);
        }
        if (this.pressure < 20) {
            this.pressure += 6;
        }
        if (this.pressure > 20 && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, state, 10);
            level.m_220407_(GameEvent.f_157796_, pos, GameEvent.Context.m_223722_((BlockState)state));
            block = state.m_60734_();
            if (block instanceof IHeavyDoor) {
                IHeavyDoor heavy = (IHeavyDoor)block;
                heavy.sound(player, level, pos, true);
            }
            this.stopUsing(state, level, pos, player);
        }
        return InteractionResult.FAIL;
    }
}

