/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.dispenser.FishBucketDispenseItemBehavior;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import galena.oreganized.OreganizedConfig;
import galena.oreganized.compat.ColorCompat;
import galena.oreganized.compat.create.CreateCompat;
import galena.oreganized.content.block.LeadOreBlock;
import galena.oreganized.content.block.MeltableBlock;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.content.entity.LeadBoltEntity;
import galena.oreganized.data.OAdvancements;
import galena.oreganized.data.OBiomeTags;
import galena.oreganized.data.OBlockStates;
import galena.oreganized.data.OBlockTags;
import galena.oreganized.data.ODamageTags;
import galena.oreganized.data.OEntityTags;
import galena.oreganized.data.OFluidTags;
import galena.oreganized.data.OItemModels;
import galena.oreganized.data.OItemTags;
import galena.oreganized.data.OLang;
import galena.oreganized.data.OLootTables;
import galena.oreganized.data.ORecipes;
import galena.oreganized.data.ORegistries;
import galena.oreganized.data.OSoundDefinitions;
import galena.oreganized.data.OSpriteSourceProvider;
import galena.oreganized.index.OAttributes;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OFeatures;
import galena.oreganized.index.OFluids;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OPaintingVariants;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OPotions;
import galena.oreganized.index.OStructures;
import galena.oreganized.network.OreganizedNetwork;
import galena.oreganized.world.AddItemLootModifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.core.Position;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infernalstudios.shieldexp.init.ItemsInit;
import umpaz.nethersdelight.common.registry.NDItems;
import vectorwing.farmersdelight.common.registry.ModItems;

@Mod(value="oreganized")
public class Oreganized {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "oreganized";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("oreganized");
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"oreganized");

    public static ResourceLocation modLoc(String location) {
        return new ResourceLocation(MOD_ID, location);
    }

    public Oreganized() {
        DeferredRegister[] registers;
        IEventBus modBus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        OreganizedConfig.register();
        modBus.addListener(this::setup);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::gatherData);
        modBus.addListener(this::buildCreativeModeTabContents);
        forgeBus.addListener(this::injectVillagerTrades);
        LOOT_MODIFIERS.register("add_item", () -> AddItemLootModifier.CODEC);
        for (DeferredRegister register : registers = new DeferredRegister[]{OEffects.EFFECTS, OEntityTypes.ENTITIES, OFluids.FLUIDS, OFluids.TYPES, OParticleTypes.PARTICLES, OPotions.POTIONS, OStructures.STRUCTURES, OFeatures.FEATURES, OPaintingVariants.PAINTING_VARIANTS, OAttributes.ATTRIBUTES, LOOT_MODIFIERS}) {
            register.register(modBus);
        }
        REGISTRY_HELPER.register(modBus);
        OreganizedNetwork.register();
        if (ModList.get().isLoaded("create")) {
            CreateCompat.register();
        }
    }

    private void injectVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35595_) {
            ((List)event.getTrades().get(5)).add(new BasicItemListing(14, new ItemStack((ItemLike)OBlocks.GARGOYLE.get()), 5, 30, 0.05f));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)OFluids.MOLTEN_LEAD_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, pos, relativePos, fluidState) -> level.m_6425_(relativePos).m_205070_(FluidTags.f_13131_) && fluidState.m_76170_(), fluidState -> ((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_49966_()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)OFluids.MOLTEN_LEAD_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, blockPos, relativePos, fluidState) -> level.m_6425_(relativePos).m_205070_(FluidTags.f_13132_) && fluidState.m_76170_(), (level, pos, relativePos, fluidState) -> {
            LeadOreBlock.spawnCloud(level, pos, 2.0f);
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            level.m_46796_(1501, pos, 0);
        }));
        event.enqueueWork(() -> {
            Map EMPTY = CauldronInteraction.f_175606_;
            Map WATER = CauldronInteraction.f_175607_;
            Map LAVA = CauldronInteraction.f_175608_;
            Map POWDER_SNOW = CauldronInteraction.f_175609_;
            Map<Item, CauldronInteraction> LEAD = MoltenLeadCauldronBlock.INTERACTION_MAP;
            EMPTY.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            WATER.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LAVA.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            POWDER_SNOW.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LEAD.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            if (((Boolean)OreganizedConfig.COMMON.cauldronLeadMelting.get()).booleanValue()) {
                EMPTY.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                WATER.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                LAVA.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                POWDER_SNOW.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
            }
            LEAD.put(Items.f_41852_, MoltenLeadCauldronBlock.EMPTY_LEAD_BLOCK);
            LEAD.put(Items.f_42446_, MoltenLeadCauldronBlock.EMPTY_MOLTEN_LEAD);
            CauldronInteraction.m_175647_(MoltenLeadCauldronBlock.INTERACTION_MAP);
            PotionBrewing.m_43513_((Potion)Potions.f_43599_, (Item)((Item)OItems.REFINED_ASBESTOS.get()), (Potion)((Potion)OPotions.LUNG_DAMAGE.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43599_, (Item)((Item)OItems.LEAD_INGOT.get()), (Potion)((Potion)OPotions.STUNNING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)OPotions.STUNNING.get()), (Item)Items.f_42451_, (Potion)((Potion)OPotions.LONG_STUNNING.get()));
            FireBlock fire = (FireBlock)Blocks.f_50083_;
            fire.m_53444_((Block)OBlocks.SHRAPNEL_BOMB.get(), 15, 100);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)OItems.LEAD_BOLT.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position pos, ItemStack stack) {
                    LeadBoltEntity entity = new LeadBoltEntity((EntityType<? extends LeadBoltEntity>)((EntityType)OEntityTypes.LEAD_BOLT.get()), level, pos);
                    entity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    return entity;
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)OItems.MOLTEN_LEAD_BUCKET.get()), (DispenseItemBehavior)new FishBucketDispenseItemBehavior());
            Stream.of("lead_bolt_crates1", "lead_bolt_crates2").forEach(name -> DataUtil.addToJigsawPattern((ResourceLocation)new ResourceLocation("pillager_outpost/features"), $ -> (StructurePoolElement)StructurePoolElement.m_210507_((String)("oreganized:pillager_outpost/" + name)).apply(StructureTemplatePool.Projection.RIGID), (int)1));
        });
        ImmutableBiMap.Builder waxedBlocks = new ImmutableBiMap.Builder();
        waxedBlocks.put((Object)((Block)OBlocks.WAXED_SPOTTED_GLANCE.get()), (Object)((Block)OBlocks.SPOTTED_GLANCE.get()));
        OBlocks.WAXED_CONCRETE_POWDER.forEach((color, waxed) -> {
            Block unwaxed = ColorCompat.getColoredBlock("concrete_powder", color);
            waxedBlocks.put((Object)((Block)waxed.get()), (Object)unwaxed);
        });
        OBlocks.WAXED_BLOCKS = waxedBlocks.build();
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture future = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        OLang lang = new OLang(output);
        generator.addProvider(client, (DataProvider)new OBlockStates(output, helper));
        generator.addProvider(client, (DataProvider)new OItemModels(output, helper));
        generator.addProvider(client, (DataProvider)lang);
        generator.addProvider(client, (DataProvider)new OSoundDefinitions(output, helper));
        generator.addProvider(client, (DataProvider)new OSpriteSourceProvider(output, helper));
        generator.addProvider(server, (DataProvider)new ORecipes(output));
        generator.addProvider(server, (DataProvider)new OLootTables(output));
        OBlockTags blockTags = new OBlockTags(output, future, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new OItemTags(output, future, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new OEntityTags(output, future, helper));
        generator.addProvider(server, (DataProvider)new OAdvancements(output, future, helper, lang));
        generator.addProvider(server, (DataProvider)new OFluidTags(output, future, helper));
        ORegistries datapackProvider = new ORegistries(output, future);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(server, (DataProvider)datapackProvider);
        generator.addProvider(server, (DataProvider)new OBiomeTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new ODamageTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Oreganized resources"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
    }

    @SubscribeEvent
    public void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tab = event.getTabKey();
        MutableHashedLinkedMap entries = event.getEntries();
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151034_, OBlocks.GLANCE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE.get(), OBlocks.SPOTTED_GLANCE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.SPOTTED_GLANCE.get(), OBlocks.GLANCE_STAIRS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE_STAIRS.get(), OBlocks.GLANCE_SLAB);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE_SLAB.get(), OBlocks.GLANCE_WALL);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE_WALL.get(), OBlocks.CHISELED_GLANCE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.CHISELED_GLANCE.get(), OBlocks.POLISHED_GLANCE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.POLISHED_GLANCE.get(), OBlocks.POLISHED_GLANCE_STAIRS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.POLISHED_GLANCE_STAIRS.get(), OBlocks.POLISHED_GLANCE_SLAB);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.POLISHED_GLANCE_SLAB.get(), OBlocks.GLANCE_BRICKS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE_BRICKS.get(), OBlocks.GLANCE_BRICK_STAIRS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE_BRICK_STAIRS.get(), OBlocks.GLANCE_BRICK_SLAB);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE_BRICK_SLAB.get(), OBlocks.GLANCE_BRICK_WALL);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.GLANCE_BRICK_WALL.get(), OBlocks.WAXED_SPOTTED_GLANCE);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42153_, OBlocks.SILVER_BLOCK);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42791_, OBlocks.ELECTRUM_BLOCK);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150992_, OBlocks.LEAD_BLOCK);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.LEAD_BLOCK.get(), OBlocks.ASBESTOS_BLOCK);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.ASBESTOS_BLOCK.get(), OBlocks.CUT_LEAD);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.CUT_LEAD.get(), OBlocks.LEAD_BRICKS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.LEAD_PILLAR.get(), OBlocks.CUT_LEAD);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.LEAD_BRICKS.get(), OBlocks.LEAD_PILLAR);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50183_, OBlocks.LEAD_BARS);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50087_, OBlocks.LEAD_BOLT_CRATE);
        OBlocks.CRYSTAL_GLASS.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42027_, (Supplier)entry.getValue()));
        OBlocks.CRYSTAL_GLASS_PANES.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42265_, (Supplier)entry.getValue()));
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150966_, OBlocks.LEAD_ORE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.LEAD_ORE.get(), OBlocks.DEEPSLATE_LEAD_ORE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150967_, OBlocks.SILVER_ORE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.SILVER_ORE.get(), OBlocks.DEEPSLATE_SILVER_ORE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.DEEPSLATE_SILVER_ORE.get(), OBlocks.ASBESTOS_ORE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150996_, OBlocks.RAW_LEAD_BLOCK);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150997_, OBlocks.RAW_SILVER_BLOCK);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OBlocks.RAW_SILVER_BLOCK.get(), OBlocks.RAW_ASBESTOS_BLOCK);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50126_, OBlocks.GROOVED_ICE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50354_, OBlocks.GROOVED_PACKED_ICE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50568_, OBlocks.GROOVED_BLUE_ICE);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41859_, OBlocks.GARGOYLE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42693_, OItems.SHRAPNEL_BOMB_MINECART);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41996_, OBlocks.SHRAPNEL_BOMB);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50261_, OBlocks.LEAD_BULB);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50166_, OBlocks.LEAD_DOOR);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50376_, OBlocks.LEAD_TRAPDOOR);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42394_, OItems.ELECTRUM_SHOVEL);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.ELECTRUM_SHOVEL.get(), OItems.ELECTRUM_PICKAXE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.ELECTRUM_PICKAXE.get(), OItems.ELECTRUM_AXE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.ELECTRUM_AXE.get(), OItems.ELECTRUM_HOE);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42455_, OItems.MOLTEN_LEAD_BUCKET);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151059_, OItems.SILVER_MIRROR);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42693_, OItems.SHRAPNEL_BOMB_MINECART);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_220217_, OItems.MUSIC_DISC_STRUCTURE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42574_, OItems.SCRIBE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42409_, OItems.FLINT_AND_PEWTER);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42393_, OItems.ELECTRUM_SWORD);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42480_, OItems.ELECTRUM_HELMET);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.ELECTRUM_HELMET.get(), OItems.ELECTRUM_CHESTPLATE);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.ELECTRUM_CHESTPLATE.get(), OItems.ELECTRUM_LEGGINGS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.ELECTRUM_LEGGINGS.get(), OItems.ELECTRUM_BOOTS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41996_, OBlocks.SHRAPNEL_BOMB);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42412_, OItems.LEAD_BOLT);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151051_, OItems.RAW_LEAD);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)OItems.RAW_LEAD.get(), OItems.RAW_ASBESTOS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151053_, OItems.RAW_SILVER);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42749_, OItems.LEAD_NUGGET);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42587_, OItems.SILVER_NUGGET);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42416_, OItems.ELECTRUM_NUGGET);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151052_, OItems.LEAD_INGOT);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42534_, OItems.REFINED_ASBESTOS);
        Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42417_, OItems.SILVER_INGOT);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42419_, OItems.ELECTRUM_INGOT);
        Oreganized.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_265918_, OItems.ELECTRUM_UPGRADE_SMITHING_TEMPLATE);
        if (ModList.get().isLoaded("farmersdelight")) {
            Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ModItems.NETHERITE_KNIFE.get(), OItems.ELECTRUM_KNIFE);
        }
        if (ModList.get().isLoaded("shieldexp")) {
            Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ItemsInit.NETHERITE_SHIELD.get(), OItems.ELECTRUM_SHIELD);
        }
        if (ModList.get().isLoaded("nethersdelight")) {
            Oreganized.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)NDItems.NETHERITE_MACHETE.get(), OItems.ELECTRUM_MACHETE);
        }
    }

    private static void putAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike after, Supplier<? extends ItemLike> supplier) {
        ItemLike key = supplier.get();
        if (!entries.contains((Object)new ItemStack(after))) {
            return;
        }
        entries.putAfter((Object)new ItemStack(after), (Object)new ItemStack(key), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void putBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike before, Supplier<? extends ItemLike> supplier) {
        ItemLike key = supplier.get();
        if (!entries.contains((Object)new ItemStack(before))) {
            return;
        }
        entries.putBefore((Object)new ItemStack(before), (Object)new ItemStack(key), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

