/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities.ModCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WreathCapability
implements ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<WreathCapability> lazyOptional = LazyOptional.of(() -> this);
    private final Map<BlockPos, WreathData> wreathBlocks = new HashMap<BlockPos, WreathData>();

    public void invalidate() {
        this.lazyOptional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ModCapabilities.WREATH_CAPABILITY ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag total = new CompoundTag();
        int i = 0;
        for (BlockPos pos : this.wreathBlocks.keySet()) {
            NbtUtils.m_129224_((BlockPos)pos);
            total.m_128365_("" + i, (Tag)NbtUtils.m_129224_((BlockPos)pos));
            ++i;
        }
        total.m_128405_("Count", i);
        return total;
    }

    public void deserializeNBT(CompoundTag total) {
        for (int i = 0; i < total.m_128451_("Count"); ++i) {
            CompoundTag tag = total.m_128469_("" + i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag);
            this.addWreath(pos);
        }
    }

    public WreathData addWreath(BlockPos pos) {
        return this.wreathBlocks.computeIfAbsent(pos, WreathData::new);
    }

    public void removeWreath(BlockPos p, Level level, boolean animationAndDrop) {
        this.wreathBlocks.remove(p);
        if (animationAndDrop) {
            ItemEntity itementity = new ItemEntity(level, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, ModRegistry.WREATH.get().m_5456_().m_7968_());
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
            level.m_46796_(2001, p, Block.m_49956_((BlockState)ModRegistry.WREATH.get().m_49966_()));
        }
    }

    public Map<BlockPos, WreathData> getWreathBlocks() {
        return this.wreathBlocks;
    }

    public boolean hasWreath(BlockPos pos) {
        return this.wreathBlocks.containsKey(pos);
    }

    public void refreshWreathVisual(BlockPos pos, Level level) {
        if (level.m_46749_(pos)) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof DoorBlock) {
                Direction dir = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
                boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
                boolean hinge = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
                WreathData data = this.addWreath(pos);
                data.face = dir;
                data.hinge = hinge;
                data.open = open;
                if (data.needsInitialization) {
                    this.calculateDoorDimensions(level, pos, state, data);
                    data.needsInitialization = false;
                }
            } else {
                this.removeWreath(pos, level, false);
            }
        }
    }

    private void calculateDoorDimensions(Level level, BlockPos pos, BlockState state, WreathData data) {
        double back;
        double front;
        state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)DoorBlock.f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.FALSE)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)DoorHingeSide.RIGHT);
        VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
        AABB bounds = shape.m_83215_();
        if (bounds.f_82291_ - bounds.f_82288_ >= 1.0) {
            front = bounds.f_82290_ - 1.0;
            back = -bounds.f_82293_;
            data.closedDimensions = Pair.of((Object)Float.valueOf((float)front), (Object)Float.valueOf((float)back));
        }
        state = (BlockState)((BlockState)state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.TRUE)).m_61124_((Property)DoorBlock.f_52726_, (Comparable)Direction.EAST);
        shape = state.m_60808_((BlockGetter)level, pos);
        bounds = shape.m_83215_();
        if (bounds.f_82291_ - bounds.f_82288_ >= 1.0) {
            front = bounds.f_82290_ - 1.0;
            back = -bounds.f_82293_;
            data.openDimensions = Pair.of((Object)Float.valueOf((float)front), (Object)Float.valueOf((float)back));
        }
    }

    public void refreshClientBlocksVisuals(Level level) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>(this.wreathBlocks.keySet());
        positions.forEach(p -> this.refreshWreathVisual((BlockPos)p, level));
    }

    public void updateAllBlocks(ServerLevel level) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>(this.wreathBlocks.keySet());
        positions.forEach(p -> {
            BlockState state;
            if (level.m_46749_(p) && !((state = level.m_8055_(p)).m_60734_() instanceof DoorBlock)) {
                this.removeWreath((BlockPos)p, (Level)level, true);
            }
        });
    }

    public static class WreathData {
        private Direction face = Direction.NORTH;
        private boolean open = true;
        private boolean hinge = true;
        private boolean needsInitialization = true;
        private Pair<Float, Float> openDimensions = null;
        private Pair<Float, Float> closedDimensions = null;

        public WreathData(BlockPos pos) {
        }

        public Direction getDirection() {
            if (this.open) {
                return this.hinge ? this.face.m_122428_() : this.face.m_122427_();
            }
            return this.face;
        }

        public boolean isOpen() {
            return this.open;
        }

        public boolean isHinge() {
            return this.hinge;
        }

        public Pair<Float, Float> getDimensions() {
            return this.open ? this.openDimensions : this.closedDimensions;
        }
    }
}

