/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import malte0811.ferritecore.ducks.BlockStateCacheAccess;
import malte0811.ferritecore.hash.ArrayVoxelShapeHash;
import malte0811.ferritecore.hash.VoxelShapeHash;
import malte0811.ferritecore.mixin.blockstatecache.ArrayVSAccess;
import malte0811.ferritecore.mixin.blockstatecache.SliceShapeAccess;
import malte0811.ferritecore.util.Constants;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BlockStateCacheImpl {
    public static final Map<ArrayVSAccess, ArrayVSAccess> CACHE_COLLIDE = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ArrayVoxelShapeHash.INSTANCE);
    public static final Map<VoxelShape, Pair<VoxelShape, VoxelShape[]>> CACHE_PROJECT = new Object2ObjectOpenCustomHashMap((Hash.Strategy)VoxelShapeHash.INSTANCE);
    public static final Map<boolean[], boolean[]> CACHE_FACE_STURDY = new Object2ObjectOpenCustomHashMap(BooleanArrays.HASH_STRATEGY);
    private static final Supplier<Function<BlockBehaviour.BlockStateBase, BlockStateCacheAccess>> GET_CACHE = Suppliers.memoize(() -> {
        try {
            String cacheName = Constants.PLATFORM_HOOKS.computeBlockstateCacheFieldName();
            Field cacheField = BlockBehaviour.BlockStateBase.class.getDeclaredField(cacheName);
            cacheField.setAccessible(true);
            MethodHandle getter = MethodHandles.lookup().unreflectGetter(cacheField);
            return state -> {
                try {
                    return getter.invoke((BlockBehaviour.BlockStateBase)state);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            };
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    });
    private static final ThreadLocal<BlockStateCacheAccess> LAST_CACHE = new ThreadLocal();

    public static void deduplicateCachePre(BlockBehaviour.BlockStateBase state) {
        LAST_CACHE.set(GET_CACHE.get().apply(state));
    }

    public static void deduplicateCachePost(BlockBehaviour.BlockStateBase state) {
        BlockStateCacheAccess newCache = GET_CACHE.get().apply(state);
        if (newCache != null) {
            BlockStateCacheAccess oldCache = LAST_CACHE.get();
            BlockStateCacheImpl.deduplicateCollisionShape(newCache, oldCache);
            BlockStateCacheImpl.deduplicateRenderShapes(newCache, oldCache);
            BlockStateCacheImpl.deduplicateFaceSturdyArray(newCache, oldCache);
            LAST_CACHE.set(null);
        }
    }

    private static void deduplicateCollisionShape(BlockStateCacheAccess newCache, @Nullable BlockStateCacheAccess oldCache) {
        VoxelShape dedupedCollisionShape;
        if (oldCache != null && VoxelShapeHash.INSTANCE.equals(oldCache.getCollisionShape(), newCache.getCollisionShape())) {
            dedupedCollisionShape = oldCache.getCollisionShape();
        } else {
            dedupedCollisionShape = newCache.getCollisionShape();
            if (dedupedCollisionShape instanceof ArrayVSAccess) {
                ArrayVSAccess access = (ArrayVSAccess)dedupedCollisionShape;
                dedupedCollisionShape = (VoxelShape)CACHE_COLLIDE.computeIfAbsent(access, Function.identity());
            }
        }
        BlockStateCacheImpl.replaceInternals(dedupedCollisionShape, newCache.getCollisionShape());
        newCache.setCollisionShape(dedupedCollisionShape);
    }

    private static void deduplicateRenderShapes(BlockStateCacheAccess newCache, @Nullable BlockStateCacheAccess oldCache) {
        Pair newPair;
        VoxelShape oldRenderShape;
        VoxelShape newRenderShape = BlockStateCacheImpl.getRenderShape(newCache.getOcclusionShapes());
        if (newRenderShape == null) {
            return;
        }
        Pair dedupedRenderShapes = null;
        if (oldCache != null && VoxelShapeHash.INSTANCE.equals(newRenderShape, oldRenderShape = BlockStateCacheImpl.getRenderShape(oldCache.getOcclusionShapes()))) {
            dedupedRenderShapes = Pair.of((Object)oldRenderShape, (Object)oldCache.getOcclusionShapes());
        }
        if (dedupedRenderShapes == null && (dedupedRenderShapes = CACHE_PROJECT.putIfAbsent(newRenderShape, (Pair<VoxelShape, VoxelShape[]>)(newPair = Pair.of((Object)newRenderShape, (Object)newCache.getOcclusionShapes())))) == null) {
            dedupedRenderShapes = newPair;
        }
        BlockStateCacheImpl.replaceInternals((VoxelShape)dedupedRenderShapes.getLeft(), newRenderShape);
        newCache.setOcclusionShapes((VoxelShape[])dedupedRenderShapes.getRight());
    }

    private static void deduplicateFaceSturdyArray(BlockStateCacheAccess newCache, @Nullable BlockStateCacheAccess oldCache) {
        boolean[] dedupedFaceSturdy = oldCache != null && Arrays.equals(oldCache.getFaceSturdy(), newCache.getFaceSturdy()) ? oldCache.getFaceSturdy() : CACHE_FACE_STURDY.computeIfAbsent(newCache.getFaceSturdy(), Function.identity());
        newCache.setFaceSturdy(dedupedFaceSturdy);
    }

    private static void replaceInternals(VoxelShape toKeep, VoxelShape toReplace) {
        if (toKeep instanceof ArrayVoxelShape) {
            ArrayVoxelShape keepArray = (ArrayVoxelShape)toKeep;
            if (toReplace instanceof ArrayVoxelShape) {
                ArrayVoxelShape replaceArray = (ArrayVoxelShape)toReplace;
                BlockStateCacheImpl.replaceInternals(keepArray, replaceArray);
            }
        }
    }

    public static void replaceInternals(ArrayVoxelShape toKeep, ArrayVoxelShape toReplace) {
        if (toKeep == toReplace) {
            return;
        }
        ArrayVSAccess toReplaceAccess = (ArrayVSAccess)toReplace;
        ArrayVSAccess toKeepAccess = (ArrayVSAccess)toKeep;
        toReplaceAccess.setXPoints(toKeepAccess.getXPoints());
        toReplaceAccess.setYPoints(toKeepAccess.getYPoints());
        toReplaceAccess.setZPoints(toKeepAccess.getZPoints());
        toReplaceAccess.setFaces(toKeepAccess.getFaces());
        toReplaceAccess.setShape(toKeepAccess.getShape());
    }

    @Nullable
    private static VoxelShape getRenderShape(@Nullable VoxelShape[] projected) {
        if (projected != null) {
            for (VoxelShape side : projected) {
                if (!(side instanceof SliceShapeAccess)) continue;
                SliceShapeAccess slice = (SliceShapeAccess)side;
                return slice.getDelegate();
            }
        }
        return null;
    }
}

