/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MagneticWeaponEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class GalenaGauntletItem
extends Item {
    public GalenaGauntletItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(400).m_41497_(Rarity.UNCOMMON));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack;
        boolean crystallization;
        ItemStack otherHand = interactionHand == InteractionHand.MAIN_HAND ? player.m_21120_(InteractionHand.OFF_HAND) : player.m_21120_(InteractionHand.MAIN_HAND);
        if (otherHand.m_204117_((crystallization = (itemstack = player.m_21120_(interactionHand)).getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.CRYSTALLIZATION.get()) > 0) ? ACTagRegistry.GALENA_GAUNTLET_CRYSTALLIZATION_ITEMS : ACTagRegistry.MAGNETIC_ITEMS)) {
            if (!player.m_7500_()) {
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player1.m_7655_()));
            }
            player.m_6672_(interactionHand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean m_6832_(ItemStack item, ItemStack repairItem) {
        return repairItem.m_150930_(((Block)ACBlockRegistry.PACKED_GALENA.get()).m_5456_()) || super.m_6832_(item, repairItem);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity player, int useTimeLeft) {
        super.m_5551_(stack, level, player, useTimeLeft);
        if (player instanceof Player) {
            Player realPlayer = (Player)player;
            realPlayer.m_36335_().m_41524_((Item)this, 5);
        }
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)player);
        player.m_216990_((SoundEvent)ACSoundRegistry.GALENA_GAUNTLET_STOP.get());
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int timeUsing) {
        super.m_5929_(level, living, stack, timeUsing);
        InteractionHand otherHand = InteractionHand.MAIN_HAND;
        if (living.m_21120_(InteractionHand.OFF_HAND) == stack) {
            otherHand = InteractionHand.MAIN_HAND;
        }
        if (living.m_21120_(InteractionHand.MAIN_HAND) == stack) {
            otherHand = InteractionHand.OFF_HAND;
        }
        AlexsCaves.PROXY.playWorldSound(living, (byte)11);
        ItemStack otherStack = living.m_21120_(otherHand);
        boolean otherMagneticWeaponsInUse = false;
        boolean crystallization = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.CRYSTALLIZATION.get()) > 0;
        if (otherStack.m_204117_(crystallization ? ACTagRegistry.GALENA_GAUNTLET_CRYSTALLIZATION_ITEMS : ACTagRegistry.MAGNETIC_ITEMS)) {
            for (MagneticWeaponEntity magneticWeapon : level.m_45976_(MagneticWeaponEntity.class, living.m_20191_().m_82377_(64.0, 64.0, 64.0))) {
                Entity controller = magneticWeapon.getController();
                if (controller == null || !controller.m_7306_((Entity)living)) continue;
                otherMagneticWeaponsInUse = true;
                break;
            }
            if (!otherMagneticWeaponsInUse) {
                MagneticWeaponEntity magneticWeapon;
                ItemStack copy = otherStack.m_41777_();
                otherStack.m_41764_(0);
                magneticWeapon = (MagneticWeaponEntity)((EntityType)ACEntityRegistry.MAGNETIC_WEAPON.get()).m_20615_(level);
                magneticWeapon.setItemStack(copy);
                magneticWeapon.m_146884_(living.m_20182_().m_82520_(0.0, 1.0, 0.0));
                magneticWeapon.setControllerUUID(living.m_20148_());
                level.m_7967_((Entity)magneticWeapon);
            }
        } else if (!otherStack.m_41619_()) {
            living.m_5810_();
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        boolean using;
        super.m_6883_(stack, level, entity, i, held);
        boolean bl = using = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21211_().equals(stack);
        if (level.f_46443_) {
            int useTime = GalenaGauntletItem.getUseTime(stack);
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_("PrevUseTime") != tag.m_128451_("UseTime")) {
                tag.m_128405_("PrevUseTime", GalenaGauntletItem.getUseTime(stack));
            }
            if (using && (float)useTime < 5.0f) {
                GalenaGauntletItem.setUseTime(stack, useTime + 1);
            }
            if (!using && (float)useTime > 0.0f) {
                GalenaGauntletItem.setUseTime(stack, useTime - 1);
            }
        }
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("PrevUseTime", GalenaGauntletItem.getUseTime(stack));
        tag.m_128405_("UseTime", useTime);
    }

    public static int getUseTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("UseTime") : 0;
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevUseTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("UseTime") : 0.0f;
        return prev + f * (current - prev);
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.OFFHAND;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)ACItemRegistry.GALENA_GAUNTLET.get()) || !newStack.m_150930_((Item)ACItemRegistry.GALENA_GAUNTLET.get());
    }
}

