/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.BrainiacEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class ThrownWasteDrumEntity
extends Entity {
    private static final EntityDataAccessor<Integer> ON_GROUND_FOR = SynchedEntityData.m_135353_(ThrownWasteDrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAX_TIME = 20;
    private BlockPos removeWasteAt = null;

    public ThrownWasteDrumEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownWasteDrumEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.THROWN_WASTE_DRUM.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.9));
        if (this.m_20096_()) {
            this.setOnGroundFor(this.getOnGroundFor() + 1);
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.7, 0.7));
        }
        if (this.m_20184_().m_82553_() > (double)0.03f) {
            AABB killBox = this.m_20191_();
            boolean b = false;
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, killBox)) {
                if (entity instanceof BrainiacEntity) continue;
                b = true;
                entity.m_6469_(ACDamageTypes.causeAcidDamage(this.m_9236_().m_9598_()), 2.0f);
            }
            if (b) {
                this.m_20256_(this.m_20184_().m_82542_(0.2, 1.0, 0.2));
            }
        }
        if (this.getOnGroundFor() >= 20 && !this.m_9236_().f_46443_) {
            if (this.getOnGroundFor() == 20) {
                BlockPos landed = this.m_20183_();
                while (landed.m_123342_() < this.m_9236_().m_151558_() && (!this.m_9236_().m_8055_(landed).m_60795_() || !this.m_9236_().m_8055_(landed).m_60819_().m_76178_() && this.m_9236_().m_8055_(landed).m_60819_().getFluidType() != ACFluidRegistry.ACID_FLUID_TYPE.get())) {
                    landed = landed.m_7494_();
                }
                this.removeWasteAt = landed;
                if (this.m_9236_().m_8055_(this.removeWasteAt).m_60795_()) {
                    BlockState fluid = ((LiquidBlock)ACBlockRegistry.ACID.get()).m_49966_();
                    this.m_9236_().m_46597_(this.removeWasteAt, fluid);
                }
            }
            if (this.getOnGroundFor() >= 35 && this.removeWasteAt != null) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                if (this.m_9236_().m_6425_(this.removeWasteAt).getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
                    this.m_9236_().m_46597_(this.removeWasteAt, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ON_GROUND_FOR, (Object)0);
    }

    public int getOnGroundFor() {
        return (Integer)this.f_19804_.m_135370_(ON_GROUND_FOR);
    }

    public void setOnGroundFor(int time) {
        this.f_19804_.m_135381_(ON_GROUND_FOR, (Object)time);
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }
}

