/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TubeWormBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape STRAIGHT_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_TURN_NORTH = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_TURN_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_TURN_SOUTH = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_TURN_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_ELBOW_NORTH = ACMath.buildShape(SHAPE_TURN_NORTH, STRAIGHT_SHAPE);
    private static final VoxelShape SHAPE_ELBOW_EAST = ACMath.buildShape(SHAPE_TURN_EAST, STRAIGHT_SHAPE);
    private static final VoxelShape SHAPE_ELBOW_SOUTH = ACMath.buildShape(SHAPE_TURN_SOUTH, STRAIGHT_SHAPE);
    private static final VoxelShape SHAPE_ELBOW_WEST = ACMath.buildShape(SHAPE_TURN_WEST, STRAIGHT_SHAPE);
    public static final EnumProperty<TubeShape> TUBE_TYPE = EnumProperty.m_61587_((String)"type", TubeShape.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public TubeWormBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.WHITE).m_60999_().m_60978_(2.0f).m_60918_(ACSoundTypes.TUBE_WORM));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(TUBE_TYPE, (Comparable)((Object)TubeShape.STRAIGHT)));
    }

    public static boolean canSupportWormAt(Level level, BlockState state, BlockPos blockPos) {
        if (state.m_60713_((Block)ACBlockRegistry.TUBE_WORM.get()) && state.m_61143_(TUBE_TYPE) != TubeShape.TURN) {
            BlockState aboveState = level.m_8055_(blockPos.m_7494_());
            return aboveState.m_60819_().m_205070_(FluidTags.f_13131_) && !aboveState.m_60659_((BlockGetter)level, blockPos.m_7494_(), Direction.DOWN, SupportType.CENTER);
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(TUBE_TYPE) == TubeShape.STRAIGHT) {
            return STRAIGHT_SHAPE;
        }
        if (state.m_61143_(TUBE_TYPE) == TubeShape.TURN) {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_TURN_NORTH;
                }
                case EAST: {
                    return SHAPE_TURN_EAST;
                }
                case SOUTH: {
                    return SHAPE_TURN_SOUTH;
                }
                case WEST: {
                    return SHAPE_TURN_WEST;
                }
            }
        } else {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_ELBOW_NORTH;
                }
                case EAST: {
                    return SHAPE_ELBOW_EAST;
                }
                case SOUTH: {
                    return SHAPE_ELBOW_SOUTH;
                }
                case WEST: {
                    return SHAPE_ELBOW_WEST;
                }
            }
        }
        return STRAIGHT_SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState prior = state;
        BlockState above = levelAccessor.m_8055_(blockPos.m_7494_());
        if (state1.m_60713_((Block)this) && direction != null && state.m_61143_(TUBE_TYPE) == TubeShape.STRAIGHT && !above.m_60713_((Block)this)) {
            if (direction.m_122434_().m_122479_()) {
                BlockState below = levelAccessor.m_8055_(blockPos.m_7495_());
                prior = below.m_60659_((BlockGetter)levelAccessor, blockPos.m_7495_(), Direction.UP, SupportType.CENTER) ? (BlockState)((BlockState)prior.m_61124_(TUBE_TYPE, (Comparable)((Object)TubeShape.TURN))).m_61124_((Property)FACING, (Comparable)direction) : (BlockState)((BlockState)prior.m_61124_(TUBE_TYPE, (Comparable)((Object)TubeShape.ELBOW))).m_61124_((Property)FACING, (Comparable)direction);
            } else if (direction == Direction.DOWN) {
                prior = (BlockState)prior.m_61124_(TUBE_TYPE, (Comparable)((Object)TubeShape.STRAIGHT));
            }
        }
        return prior;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_().m_121945_(direction.m_122424_());
        BlockState neighbor = levelaccessor.m_8055_(blockpos);
        BlockState aboveNeighbor = levelaccessor.m_8055_(blockpos.m_7494_());
        if (neighbor.m_60713_((Block)this)) {
            TubeShape tubeShape = (TubeShape)((Object)neighbor.m_61143_(TUBE_TYPE));
            if (tubeShape == TubeShape.STRAIGHT && aboveNeighbor.m_60713_((Block)this)) {
                return null;
            }
            if (tubeShape == TubeShape.ELBOW && direction != Direction.UP) {
                return null;
            }
            if (tubeShape == TubeShape.TURN && direction != neighbor.m_61143_((Property)FACING)) {
                return null;
            }
        }
        BlockState tube = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        if (direction.m_122434_().m_122479_()) {
            tube = (BlockState)((BlockState)tube.m_61124_(TUBE_TYPE, (Comparable)((Object)TubeShape.ELBOW))).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
        }
        return tube;
    }

    public boolean m_7898_(BlockState state, LevelReader levelAccessor, BlockPos blockPos) {
        BlockState belowState = levelAccessor.m_8055_(blockPos.m_7495_());
        if (belowState.m_60659_((BlockGetter)levelAccessor, blockPos.m_7495_(), Direction.UP, SupportType.CENTER)) {
            return true;
        }
        if (state.m_61143_(TUBE_TYPE) == TubeShape.ELBOW) {
            BlockPos offset = blockPos.m_121945_((Direction)state.m_61143_((Property)FACING));
            BlockState offsetState = levelAccessor.m_8055_(offset);
            return offsetState.m_60659_((BlockGetter)levelAccessor, offset, ((Direction)state.m_61143_((Property)FACING)).m_122424_(), SupportType.CENTER) || offsetState.m_60713_((Block)this);
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TUBE_TYPE, WATERLOGGED});
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.m_188503_(3) == 0 && TubeWormBlock.canSupportWormAt(level, state, pos) && AlexsCaves.PROXY.checkIfParticleAt((SimpleParticleType)ACParticleRegistry.TUBE_WORM.get(), pos)) {
            Vec3 center = Vec3.m_82514_((Vec3i)pos, (double)0.5);
            level.m_7106_((ParticleOptions)ACParticleRegistry.TUBE_WORM.get(), center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static enum TubeShape implements StringRepresentable
    {
        STRAIGHT("straight"),
        TURN("turn"),
        ELBOW("elbow");

        private final String name;

        private TubeShape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

