/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.worker;

import com.chaosthedude.explorerscompass.worker.StructureSearchWorker;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;

public class RandomSpreadSearchWorker
extends StructureSearchWorker<RandomSpreadStructurePlacement> {
    private int spacing;
    private int length;
    private int startSectionPosX;
    private int startSectionPosZ;
    private int x;
    private int z;

    public RandomSpreadSearchWorker(ServerLevel level, Player player, ItemStack stack, BlockPos startPos, RandomSpreadStructurePlacement placement, List<Structure> structureSet, String managerId) {
        super(level, player, stack, startPos, placement, structureSet, managerId);
        this.spacing = placement.m_205003_();
        this.startSectionPosX = SectionPos.m_123171_((int)startPos.m_123341_());
        this.startSectionPosZ = SectionPos.m_123171_((int)startPos.m_123343_());
        this.x = 0;
        this.z = 0;
        this.length = 0;
        this.finished = !level.m_7654_().m_129910_().m_246337_().m_247749_();
    }

    @Override
    public boolean hasWork() {
        return super.hasWork();
    }

    @Override
    public boolean doWork() {
        super.doWork();
        if (this.hasWork()) {
            boolean shouldSampleZ;
            boolean shouldSampleX = this.x == -this.length || this.x == this.length;
            boolean bl = shouldSampleZ = this.z == -this.length || this.z == this.length;
            if (shouldSampleX || shouldSampleZ) {
                int sampleX = this.startSectionPosX + this.spacing * this.x;
                int sampleZ = this.startSectionPosZ + this.spacing * this.z;
                ChunkPos chunkPos = ((RandomSpreadStructurePlacement)this.placement).m_227008_(this.level.m_7328_(), sampleX, sampleZ);
                this.currentPos = new BlockPos(SectionPos.m_175554_((int)chunkPos.f_45578_, (int)8), 0, SectionPos.m_175554_((int)chunkPos.f_45579_, (int)8));
                Pair<BlockPos, Structure> pair = this.getStructureGeneratingAt(chunkPos);
                ++this.samples;
                if (pair != null) {
                    this.succeed((BlockPos)pair.getFirst(), (Structure)pair.getSecond());
                }
            }
            ++this.z;
            if (this.z > this.length) {
                this.z = -this.length;
                ++this.x;
                if (this.x > this.length) {
                    this.x = -this.length;
                    ++this.length;
                }
            }
        } else if (!this.finished) {
            this.fail();
        }
        if (this.hasWork()) {
            return true;
        }
        if (!this.finished) {
            this.fail();
        }
        return false;
    }

    @Override
    protected String getName() {
        return "RandomSpreadSearchWorker";
    }

    @Override
    public boolean shouldLogRadius() {
        return true;
    }

    private Pair<BlockPos, Structure> getClosest() {
        for (int x = -this.length; x <= this.length; ++x) {
            boolean shouldSampleX = x == -this.length || x == this.length;
            for (int z = -this.length; z <= this.length; ++z) {
                boolean shouldSampleZ;
                boolean bl = shouldSampleZ = z == -this.length || z == this.length;
                if (!shouldSampleX && !shouldSampleZ) continue;
                int sampleX = this.startSectionPosX + this.spacing * x;
                int sampleZ = this.startSectionPosZ + this.spacing * z;
                ChunkPos chunkPos = ((RandomSpreadStructurePlacement)this.placement).m_227008_(this.level.m_7328_(), sampleX, sampleZ);
                Pair<BlockPos, Structure> pair = this.getStructureGeneratingAt(chunkPos);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }
}

