/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;

public class SmithingBackpackUpgradeRecipe
extends SmithingTransformRecipe
implements IWrapperRecipe<SmithingTransformRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final SmithingTransformRecipe compose;

    public SmithingBackpackUpgradeRecipe(SmithingTransformRecipe compose) {
        super(compose.m_6423_(), compose.f_265949_, compose.f_265888_, compose.f_265907_, compose.f_266098_);
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        ItemStack upgradedBackpack = this.f_266098_.m_41777_();
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            this.getBackpack(inv).flatMap(backpack -> Optional.ofNullable(backpack.m_41783_())).ifPresent(tag -> upgradedBackpack.m_41751_(tag.m_6426_()));
            upgradedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
                BackpackItem backpackItem = (BackpackItem)upgradedBackpack.m_41720_();
                wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
            });
        }
        return upgradedBackpack;
    }

    private Optional<ItemStack> getBackpack(Container inv) {
        ItemStack slotStack = inv.m_8020_(1);
        if (slotStack.m_41720_() instanceof BackpackItem) {
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.SMITHING_BACKPACK_UPGRADE_RECIPE_SERIALIZER.get();
    }

    public SmithingTransformRecipe getCompose() {
        return this.compose;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<SmithingTransformRecipe, SmithingBackpackUpgradeRecipe> {
        public Serializer() {
            super(SmithingBackpackUpgradeRecipe::new, RecipeSerializer.f_266093_);
        }
    }
}

