/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.valhelsia;

import com.mojang.blaze3d.platform.NativeImage;
import com.stal111.valhelsia_structures.common.block.CutPostBlock;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import com.stal111.valhelsia_structures.core.init.ModRecipes;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.every_compat.modules.forge.valhelsia.AxeCraftingRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.valhelsia.valhelsia_core.api.common.block.StrippableRotatedPillarBlock;

public class ValhelsiaStructuresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> cutStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> cutPosts;
    public final SimpleEntrySet<WoodType, Block> bundledStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> bundledPosts;

    public ValhelsiaStructuresModule(String modId) {
        super(modId, "vs");
        ResourceLocation tab = this.modRes("main");
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "stripped", this.getModBlock("stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> new PostBlock(Utils.copyPropertySafe((Block)w.log))).requiresChildren(new String[]{"stripped_log"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.strippedPosts);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", this.getModBlock("oak_post"), () -> WoodTypeRegistry.OAK_TYPE, woodType -> new CompatPostBlock(Utils.copyPropertySafe((Block)woodType.log), (WoodType)woodType)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.posts);
        this.cutStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut_stripped", this.getModBlock("cut_stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CutPostBlock(ValhelsiaStructuresModule.cutPostProperties(w))).requiresFromMap(this.strippedPosts.blocks)).requiresChildren(new String[]{"stripped_log"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("cut_posts"), Registries.f_256747_)).addTag(this.modRes("cut_posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutStrippedPosts);
        this.cutPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut", this.getModBlock("cut_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> new CompatCutPostBlock(ValhelsiaStructuresModule.cutPostProperties(w), (WoodType)w)).requiresFromMap(this.posts.blocks)).addTag(this.modRes("cut_posts"), Registries.f_256747_)).addTag(this.modRes("cut_posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutPosts);
        this.bundledStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled_stripped", this.getModBlock("bundled_stripped_oak_posts"), () -> WoodTypeRegistry.OAK_TYPE, w -> new RotatedPillarBlock(ValhelsiaStructuresModule.bundledPostProperties(w))).requiresFromMap(this.strippedPosts.blocks)).requiresChildren(new String[]{"stripped_log"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledStrippedPosts);
        this.bundledPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled", this.getModBlock("bundled_oak_posts"), () -> WoodTypeRegistry.OAK_TYPE, w -> new StrippableRotatedPillarBlock(() -> (Block)this.bundledStrippedPosts.blocks.get(w), ValhelsiaStructuresModule.bundledPostProperties(w))).requiresFromMap(this.posts.blocks)).requiresFromMap(this.bundledStrippedPosts.blocks)).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledPosts);
    }

    public static BlockBehaviour.Properties cutPostProperties(WoodType woodType) {
        return woodType.copyProperties().m_284495_(state -> ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_() == Direction.Axis.Y ? woodType.planks.m_284356_() : woodType.log.m_284356_()).m_60978_(2.0f).m_60955_();
    }

    public static BlockBehaviour.Properties bundledPostProperties(WoodType woodType) {
        return woodType.copyProperties().m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? MapColor.f_283825_ : MapColor.f_283819_);
    }

    @Override
    public void onModSetup() {
        TemplateRecipeManager.registerTemplate((RecipeSerializer)((RecipeSerializer)ModRecipes.AXE_CRAFTING_SERIALIZER.get()), AxeCraftingRecipeTemplate::new);
        super.onModSetup();
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        try {
            this.posts.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                    TextureImage newTexture = logTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    handler.getLogger().error("Failed to generate Post texture for for {} : {}", block, (Object)e);
                }
            });
            this.strippedPosts.blocks.forEach((w, block) -> {
                ResourceLocation id = Utils.getID((Block)block);
                try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/stripped_oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                    TextureImage newTexture = logTexture.makeCopy();
                    handler.addTextureIfNotPresent(manager, newId, () -> newTexture);
                    TextureImage newTop = topTexture.makeCopy();
                    this.createTopTexture(topTexture, newTop);
                    handler.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                }
                catch (Exception e) {
                    handler.getLogger().error("Failed to generate Stripped-Post texture for {} : {}", block, (Object)e);
                }
            });
        }
        catch (Exception ex) {
            handler.getLogger().error("Could not generate block texture: ", (Throwable)ex);
        }
        try (TextureImage BPTopInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_inner_m"));
             TextureImage BPTopOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_outer_m"));
             TextureImage logInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/log_top_inner_m"));
             TextureImage logOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/log_top_outer_m"));){
            this.bundledPosts.blocks.forEach((w, block) -> {
                String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_" + w.getTypeName() + "_posts";
                this.createTexture(newPath, w.log, logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_oak_posts"), this.modRes("block/bundled_posts/bundled_oak_posts_top"), handler, manager, (Block)block);
            });
            this.bundledStrippedPosts.blocks.forEach((w, block) -> {
                String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_stripped_" + w.getTypeName() + "_posts";
                this.createTexture(newPath, w.getBlockOfThis("stripped_log"), logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_stripped_oak_posts"), this.modRes("block/bundled_posts/bundled_stripped_oak_posts_top"), handler, manager, (Block)block);
            });
        }
        catch (Exception e) {
            handler.getLogger().error("Failed to open bundled_posts texture: ", (Throwable)e);
        }
    }

    private void createTexture(String newPath, Block getLogBlock, TextureImage logInnerMask, TextureImage logOuterMask, TextureImage BPTopInnerMask, TextureImage BPTopOuterMask, ResourceLocation getLogSide, ResourceLocation getLogTop, ClientDynamicResourcesHandler handler, ResourceManager manager, Block block) {
        try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
             TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, SpriteHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));
             TextureImage TextureSide = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogSide);
             TextureImage TextureTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogTop);){
            TextureImage topImage;
            TextureImage sideImage;
            NativeImage standardSize;
            McMetaFile metaSide = logSide_texture.getMcMeta();
            if (Objects.nonNull(logSide_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.m_85054_(logSide_texture.getImage());
                sideImage = TextureImage.of((NativeImage)standardSize);
            } else {
                sideImage = logTop_texture;
            }
            List targetSide = Palette.fromAnimatedImage((TextureImage)sideImage);
            Respriter respriterSide = Respriter.of((TextureImage)TextureSide);
            TextureImage recoloredSIDE = respriterSide.recolorWithAnimation(targetSide, metaSide);
            ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(newPath), recoloredSIDE);
            McMetaFile metaTop = logTop_texture.getMcMeta();
            if (Objects.nonNull(logTop_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.m_85054_(logTop_texture.getImage());
                topImage = TextureImage.of((NativeImage)standardSize);
            } else {
                topImage = logTop_texture;
            }
            List targetTopInner = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logOuterMask, (float)0.0f);
            List targetTopOuter = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logInnerMask, (float)0.0f);
            Respriter innerTopResp = Respriter.masked((TextureImage)TextureTop, (TextureImage)BPTopOuterMask);
            TextureImage recoloredwithInner = innerTopResp.recolorWithAnimation(targetTopInner, metaTop);
            Respriter outerTopResp = Respriter.masked((TextureImage)recoloredwithInner, (TextureImage)BPTopInnerMask);
            TextureImage recoloredwithOuter = targetTopOuter.size() < 3 ? outerTopResp.recolorWithAnimationOf(logTop_texture) : outerTopResp.recolorWithAnimation(targetTopOuter, metaTop);
            ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(newPath + "_top"), recoloredwithOuter);
        }
        catch (Exception e) {
            handler.getLogger().error("Failed to generate the texture for {} : {}", (Object)block, (Object)e);
        }
    }

    private void createTopTexture(TextureImage original, TextureImage newImage) {
        original.forEachFramePixel((i, x, y) -> {
            int localX = x - original.getFrameStartX(i.intValue());
            int localY = y - original.getFrameStartX(i.intValue());
            if (localX >= 5 && localX <= 10 && localY >= 5 && localY <= 10) {
                newImage.getImage().m_84988_(x - 3, y - 3, original.getImage().m_84985_(x.intValue(), y.intValue()));
            } else if (localX >= 14 && localY > 0 && localY <= 7) {
                newImage.getImage().m_84988_(x - 6, y.intValue(), original.getImage().m_84985_(x.intValue(), y.intValue()));
                newImage.getImage().m_84988_(x.intValue(), y.intValue(), 0);
            } else if (localY >= 14 && localX > 0 && localX <= 7) {
                newImage.getImage().m_84988_(x.intValue(), y - 6, original.getImage().m_84985_(x.intValue(), y.intValue()));
                newImage.getImage().m_84988_(x.intValue(), y.intValue(), 0);
            } else if (localX >= 14 && localY >= 14) {
                newImage.getImage().m_84988_(x - 6, y - 6, original.getImage().m_84985_(x.intValue(), y.intValue()));
            } else if (localX >= 10 || localY >= 10) {
                newImage.getImage().m_84988_(x.intValue(), y.intValue(), 0);
            }
        });
    }

    public static class CompatCutPostBlock
    extends CutPostBlock {
        public final WoodType woodType;

        public CompatCutPostBlock(BlockBehaviour.Properties properties, WoodType woodType) {
            super(properties);
            this.woodType = woodType;
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)this);
            Block strippedCutPost = this.woodType.getBlockOfThis("valhelsia_structures:cut_stripped_post");
            if (!context.m_43722_().canPerformAction(toolAction) || Objects.requireNonNull(location).m_135815_().contains("stripped")) {
                return null;
            }
            if (toolAction == ToolActions.AXE_STRIP && Objects.nonNull(strippedCutPost)) {
                return (BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull((Block)BuiltInRegistries.f_256975_.m_7745_(Utils.getID((Block)strippedCutPost))).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ATTACHED, (Comparable)((Boolean)state.m_61143_((Property)ATTACHED)))).m_61124_((Property)PARTS, (Comparable)((Integer)state.m_61143_((Property)PARTS)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
            }
            return null;
        }
    }

    public static class CompatPostBlock
    extends PostBlock {
        public final WoodType woodType;

        public CompatPostBlock(BlockBehaviour.Properties properties, WoodType woodType) {
            super(properties);
            this.woodType = woodType;
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)this);
            Block strippedPost = this.woodType.getBlockOfThis("valhelsia_structures:stripped_post");
            if (!context.m_43722_().canPerformAction(toolAction) || Objects.requireNonNull(location).m_135815_().contains("stripped")) {
                return null;
            }
            if (toolAction == ToolActions.AXE_STRIP && Objects.nonNull(strippedPost)) {
                return (BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.f_256975_.m_7745_(Utils.getID((Block)strippedPost))).m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)))).m_61124_((Property)ATTACHED, (Comparable)((Boolean)state.m_61143_((Property)ATTACHED)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
            }
            return null;
        }
    }
}

