/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.mixins.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import me.srrapero720.chloride.Chloride;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.Tools;
import me.srrapero720.chloride.features.DistanceCullingFeature;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EntityDistanceCullingMixin {

    @Mixin(value={BlockEntityType.class})
    public static abstract class TileEntityTypeMixin
    implements DistanceCullingFeature {
        @Unique
        private static final Marker e$IT = MarkerManager.getMarker((String)"BlockEntityType");
        @Unique
        private boolean embPlus$checked = false;
        @Unique
        private boolean embPlus$whitelisted = false;

        @Override
        public boolean chloride$whitelisted() {
            if (this.embPlus$checked) {
                return this.embPlus$whitelisted;
            }
            ResourceLocation resource = BlockEntityType.m_58954_(this.embPlus$cast());
            if (resource == null) {
                Chloride.LOGGER.warn(e$IT, "key for '{}' is null, some mod decides to broke itself, not whitelisting", (Object)this.getClass().getName());
                return false;
            }
            this.embPlus$whitelisted = Tools.isWhitelisted(resource, ChlorideConfig.tileEntityWhitelist);
            this.embPlus$checked = true;
            Chloride.LOGGER.debug(e$IT, "Whitelist checked for {}", (Object)resource.toString());
            return this.embPlus$whitelisted;
        }

        @Unique
        private BlockEntityType<?> embPlus$cast() {
            return (BlockEntityType)this;
        }
    }

    @Mixin(value={BlockEntityRenderDispatcher.class})
    public static class TileDispatcherMixin {
        @Shadow
        public Camera f_112249_;

        @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
        public <E extends BlockEntity> void render(E tile, float val, PoseStack matrix, MultiBufferSource bufferSource, CallbackInfo ci) {
            if (!ChlorideConfig.tileEntityDistanceCulling) {
                return;
            }
            boolean isWhitelisted = ((DistanceCullingFeature)tile.m_58903_()).chloride$whitelisted();
            if (!isWhitelisted && !Tools.isEntityInRange(tile.m_58899_(), this.f_112249_.m_90583_(), ChlorideConfig.tileEntityCullingDistanceY, ChlorideConfig.tileEntityCullingDistanceX)) {
                ci.cancel();
            }
        }
    }

    @Mixin(value={EntityType.class})
    public static abstract class EntityTypeMixin
    implements DistanceCullingFeature {
        @Unique
        private static final Marker e$IT = MarkerManager.getMarker((String)"EntityType");
        @Unique
        private boolean embPlus$checked = false;
        @Unique
        private boolean embPlus$whitelisted = false;

        @Shadow
        public abstract MobCategory m_20674_();

        @Override
        @Unique
        public boolean chloride$whitelisted() {
            if (this.embPlus$checked) {
                return this.embPlus$whitelisted;
            }
            ResourceLocation resource = this.embPlus$resourceLocation();
            if (resource == null) {
                Chloride.LOGGER.warn(e$IT, "key for '{}' is null, some mod decides to broke itself, not whitelisting", (Object)this.getClass().getName());
                return false;
            }
            this.embPlus$whitelisted = Tools.isWhitelisted(resource, this.m_20674_() == MobCategory.MONSTER ? ChlorideConfig.monsterWhitelist : ChlorideConfig.entityWhitelist);
            this.embPlus$checked = true;
            Chloride.LOGGER.debug(e$IT, "Whitelist checked for {}", (Object)resource.toString());
            return this.embPlus$whitelisted;
        }

        @Unique
        public ResourceLocation embPlus$resourceLocation() {
            return BuiltInRegistries.f_256780_.m_7981_(this.embPlus$cast());
        }

        @Unique
        private EntityType<?> embPlus$cast() {
            return (EntityType)this;
        }
    }

    @Mixin(value={EntityRenderDispatcher.class})
    public static class EntityDispatcherMixin {
        @Inject(at={@At(value="HEAD")}, method={"shouldRender"}, cancellable=true)
        public <E extends Entity> void inject$shouldRender(E entity, Frustum clippingHelper, double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
            int distX;
            int distY;
            MobCategory category = entity.m_6095_().m_20674_();
            if (category == MobCategory.MONSTER) {
                if (!ChlorideConfig.monsterDistanceCulling) {
                    return;
                }
                distY = ChlorideConfig.monsterCullingDistanceY;
                distX = ChlorideConfig.monsterCullingDistanceX;
            } else {
                if (!ChlorideConfig.entityDistanceCulling) {
                    return;
                }
                distY = ChlorideConfig.entityCullingDistanceY;
                distX = ChlorideConfig.entityCullingDistanceX;
            }
            boolean isWhitelisted = ((DistanceCullingFeature)entity.m_6095_()).chloride$whitelisted();
            if (!isWhitelisted && !Tools.isEntityInRange(entity, x, y, z, distY, distX)) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

