/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.elysium_api.impl.mixin.biome;

import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.jadenxgamer.elysium_api.Elysium;
import net.jadenxgamer.elysium_api.impl.biome.ElysiumBiomeHelper;
import net.jadenxgamer.elysium_api.impl.biome.ElysiumBiomeSource;
import net.jadenxgamer.elysium_api.impl.biome_replacer.BiomeReplacerDataDriven;
import net.jadenxgamer.elysium_api.impl.compat.ElysiumTerrablenderHelper;
import net.jadenxgamer.elysium_api.impl.registry.ElysiumRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraftforge.fml.loading.FMLLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiNoiseBiomeSource.class}, priority=-800)
public abstract class MultiNoiseBiomeSourceMixin {
    @Shadow
    @Final
    private Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> f_48435_;

    @Shadow
    public abstract Climate.ParameterList<Holder<Biome>> m_274409_();

    @Inject(method={"getNoiseBiome(IIILnet/minecraft/world/level/biome/Climate$Sampler;)Lnet/minecraft/core/Holder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void elysium$getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, CallbackInfoReturnable<Holder<Biome>> cir) {
        List<BiomeReplacerDataDriven> dataDrivenReplacers;
        List<ElysiumBiomeHelper.BiomeReplacer> biomeReplacers;
        Holder<Biome> replacedBiome;
        ElysiumBiomeSource sourceElysium;
        Holder<Biome> currentBiome = this.getCurrentBiome(x, y, z, sampler);
        MultiNoiseBiomeSourceMixin multiNoiseBiomeSourceMixin = this;
        if (multiNoiseBiomeSourceMixin instanceof ElysiumBiomeSource && (sourceElysium = (ElysiumBiomeSource)((Object)multiNoiseBiomeSourceMixin)).getDimension() != null && !(replacedBiome = this.replaceBiomeIfNeeded(x, z, currentBiome, biomeReplacers = ElysiumBiomeHelper.biomesForDimension(sourceElysium.getDimension()), dataDrivenReplacers = Elysium.registryAccess.m_175515_(ElysiumRegistries.BIOME_REPLACER).m_123024_().toList(), sourceElysium.getWorldSeed())).equals(currentBiome)) {
            cir.setReturnValue(replacedBiome);
        }
    }

    @Unique
    private Holder<Biome> getCurrentBiome(int x, int y, int z, Climate.Sampler sampler) {
        if (FMLLoader.getLoadingModList().getModFileById("terrablender") != null) {
            return ElysiumTerrablenderHelper.getCurrentBiome((MultiNoiseBiomeSource)this, x, y, z, sampler);
        }
        return (Holder)this.m_274409_().m_204252_(sampler.m_183445_(x, y, z));
    }

    @Unique
    private Holder<Biome> replaceBiomeIfNeeded(int x, int z, Holder<Biome> currentBiome, List<ElysiumBiomeHelper.BiomeReplacer> biomeReplacers, List<BiomeReplacerDataDriven> dataDrivenReplacers, long worldSeed) {
        HashSet<Holder<Biome>> processedBiomes = new HashSet<Holder<Biome>>();
        Random random = new Random();
        while (currentBiome != null && processedBiomes.add(currentBiome)) {
            long uniqueSeed;
            for (ElysiumBiomeHelper.BiomeReplacer biomeReplacer : biomeReplacers) {
                if (!biomeReplacer.replaceBiomes().m_203333_(currentBiome)) continue;
                uniqueSeed = this.makeCoordinatesIntoSeed(x / biomeReplacer.size(), z / biomeReplacer.size(), worldSeed) ^ (long)biomeReplacer.uniqueId().hashCode();
                random.setSeed(uniqueSeed);
                if (!(random.nextDouble() < biomeReplacer.rarity())) continue;
                return Elysium.registryAccess.m_175515_(Registries.f_256952_).m_246971_(biomeReplacer.withBiome());
            }
            for (BiomeReplacerDataDriven biomeReplacerDataDriven : dataDrivenReplacers) {
                if (!biomeReplacerDataDriven.replaceBiomes().m_203333_(currentBiome)) continue;
                uniqueSeed = this.makeCoordinatesIntoSeed(x / biomeReplacerDataDriven.size(), z / biomeReplacerDataDriven.size(), worldSeed) ^ (long)biomeReplacerDataDriven.uniqueId().hashCode();
                random.setSeed(uniqueSeed);
                if (!(random.nextDouble() < biomeReplacerDataDriven.rarity())) continue;
                return biomeReplacerDataDriven.withBiome();
            }
        }
        return currentBiome;
    }

    @Unique
    private long makeCoordinatesIntoSeed(int scaledX, int scaledZ, long worldSeed) {
        return (31L * (long)scaledX + 17L ^ 37L * (long)scaledZ + 23L ^ worldSeed) * 25214903917L;
    }
}

