/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.StonezoneModule;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public final class ModelUtils {
    private static final Pattern PATH_PATTERN = Pattern.compile("(?<folder>.*?)(?<path>/.*$)");
    private static final Set<ResourceLocation> RESOLVED_PARENTS = new HashSet<ResourceLocation>();

    public static void reset() {
        RESOLVED_PARENTS.clear();
    }

    public static ResourceLocation transformModelID(ResourceLocation id) {
        Matcher matcher = PATH_PATTERN.matcher(id.m_135815_());
        if (!matcher.find() || id.m_135827_().contains("stonezone")) {
            return id;
        }
        return StoneZone.res(matcher.group("folder") + "/" + id.m_135827_() + matcher.group("path"));
    }

    public static void addTintIndexToModelAndReplaceParent(JsonObject jsonObject, @Nullable SimpleModule module, @Nullable String ignoreIfFromStone) {
        ModelUtils.replaceParent(jsonObject, module, ignoreIfFromStone);
        ModelUtils.addTintIndexToModel(jsonObject, 0);
    }

    private static void replaceParent(JsonObject jsonObject, @Nullable SimpleModule module, @Nullable String ignoreIfFromStone) {
        if (jsonObject.has("parent")) {
            ResourceLocation oldRes = new ResourceLocation(jsonObject.get("parent").getAsString());
            String path = oldRes.m_135815_();
            int idx = path.lastIndexOf("/");
            if (ignoreIfFromStone != null && idx != -1 && path.substring(idx + 1).contains(ignoreIfFromStone) && !path.contains("/parent/") && !path.contains("template")) {
                return;
            }
            if (!oldRes.toString().matches("minecraft:(?:item/generated|builtin/generated)")) {
                ResourceLocation newRes = ModelUtils.transformModelID(oldRes);
                jsonObject.addProperty("parent", newRes.toString());
                if (module instanceof StonezoneModule) {
                    StonezoneModule stonezoneModule = (StonezoneModule)module;
                    if (!RESOLVED_PARENTS.contains(oldRes) || !oldRes.m_135827_().matches("stonezone")) {
                        stonezoneModule.markModelForModification(oldRes);
                        RESOLVED_PARENTS.add(oldRes);
                    }
                }
            }
        }
    }

    private static void addTintIndexToModel(JsonObject jsonObject, int tintIndex) {
        JsonElement elements = jsonObject.get("elements");
        if (elements != null) {
            for (JsonElement element : elements.getAsJsonArray()) {
                JsonObject elementObject;
                JsonObject faces;
                if (!(element instanceof JsonObject) || (faces = (elementObject = (JsonObject)element).getAsJsonObject("faces")) == null) continue;
                for (String key : faces.keySet()) {
                    JsonObject face = faces.getAsJsonObject(key);
                    if (face.has("tintindex")) continue;
                    face.addProperty("tintindex", (Number)tintIndex);
                }
            }
        }
    }

    public static void removeTintIndexFromModel(JsonObject jsonObject, String target) {
        JsonElement elements = jsonObject.get("elements");
        if (elements != null) {
            for (JsonElement element : elements.getAsJsonArray()) {
                JsonObject elementObject;
                JsonObject faces;
                if (!(element instanceof JsonObject) || (faces = (elementObject = (JsonObject)element).getAsJsonObject("faces")) == null) continue;
                for (String key : faces.keySet()) {
                    JsonObject face = faces.getAsJsonObject(key);
                    if (!Objects.equals(face.get("texture").getAsString(), target)) continue;
                    face.remove("tintindex");
                }
            }
        }
    }

    public static Map<ResourceLocation, JsonObject> readAllModelsAndParents(ResourceManager manager, Collection<ResourceLocation> models) {
        HashMap<ResourceLocation, JsonObject> jsonObjects = new HashMap<ResourceLocation, JsonObject>();
        for (ResourceLocation res : models) {
            if (res.m_135827_().matches("stonezone")) continue;
            ModelUtils.readJsonsRecursive(manager, res, jsonObjects);
        }
        return jsonObjects;
    }

    private static void readJsonsRecursive(ResourceManager manager, ResourceLocation res, Map<ResourceLocation, JsonObject> jsonObjects) {
        StaticResource resource = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.MODELS.getPath(res));
        if (resource != null) {
            JsonObject json = GsonHelper.m_13864_((String)new String(resource.data)).getAsJsonObject();
            jsonObjects.put(res, json);
            if (json.has("parent")) {
                ResourceLocation parent = new ResourceLocation(json.get("parent").getAsString());
                if (RESOLVED_PARENTS.contains(parent)) {
                    return;
                }
                RESOLVED_PARENTS.add(parent);
                ModelUtils.readJsonsRecursive(manager, parent, jsonObjects);
            }
        }
    }

    public static void removeTintIndexFromParentModel(String pathModel, String excludeTexture, ClientDynamicResourcesHandler handler, ResourceManager manager) {
        ResourceLocation modelResLoc = ResType.BLOCK_MODELS.getPath(StoneZone.res(pathModel));
        try (InputStream modelStream = ((Resource)manager.m_213713_(modelResLoc).orElseThrow(FileNotFoundException::new)).m_215507_();){
            JsonObject model = RPUtils.deserializeJson((InputStream)modelStream);
            ModelUtils.removeTintIndexFromModel(model, excludeTexture);
            ((DynamicTexturePack)handler.dynamicPack).addJson(StoneZone.res(pathModel), (JsonElement)model, ResType.BLOCK_MODELS);
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to modify parent model @ {} : {}", (Object)modelResLoc, (Object)e);
        }
    }
}

