/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.StoneType;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class StoneTypeRegistry
extends BlockTypeRegistry<StoneType> {
    public static final StoneTypeRegistry INSTANCE = new StoneTypeRegistry();

    public StoneTypeRegistry() {
        super(StoneType.class, "stone_type");
        this.addFinder(StoneType.Finder.vanilla("stone"));
        this.addFinder(StoneType.Finder.vanilla("andesite"));
        this.addFinder(StoneType.Finder.vanilla("diorite"));
        this.addFinder(StoneType.Finder.vanilla("granite"));
        this.addFinder(StoneType.Finder.vanilla("tuff"));
        this.addFinder(StoneType.Finder.vanilla("calcite"));
        this.addFinder(StoneType.Finder.vanilla("blackstone"));
    }

    public static StoneType getStoneType() {
        return StoneTypeRegistry.getValue("stone");
    }

    public static StoneType getAndesiteType() {
        return StoneTypeRegistry.getValue("andesite");
    }

    public static Collection<StoneType> getTypes() {
        return INSTANCE.getValues();
    }

    public static StoneType getValue(String stoneTypeId) {
        return (StoneType)INSTANCE.get(new ResourceLocation(stoneTypeId));
    }

    public StoneType getDefaultType() {
        return (StoneType)this.get(new ResourceLocation("stone"));
    }

    public Optional<StoneType> detectTypeFromBlock(Block baseblock, ResourceLocation baseRes) {
        String path = baseRes.m_135815_();
        if (baseRes.m_135827_().matches("tfc|afc") && path.matches("rock/bricks/\\w+") && (baseblock.m_49966_().m_280603_() == NoteBlockInstrument.BASEDRUM || baseblock.m_49966_().m_280603_() == NoteBlockInstrument.HARP)) {
            int index = path.lastIndexOf("/");
            String stoneName = path.substring(index + 1);
            Optional opt = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(baseRes.m_135827_(), path.replace("bricks", "raw")));
            if (opt.isPresent()) {
                return Optional.of(new StoneType(baseRes.m_247449_(stoneName), (Block)opt.get()));
            }
        }
        if (!HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.m_135827_())) {
            if (path.matches("[a-z]+(?:_(bricks|stairs)|_stone_(bricks|stairs))") && baseblock.m_49966_().m_280603_() == NoteBlockInstrument.BASEDRUM) {
                boolean isStoneTypeBlacklisted;
                String stoneName = path.substring(0, path.length() - 7);
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.m_247449_(stoneName);
                ResourceLocation idBlockTypeAlt = baseRes.m_247449_(stoneAlt);
                boolean bl = isStoneTypeBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneAlt).toString());
                if ((Objects.isNull(this.get(idBlockType)) || Objects.isNull(this.get(idBlockTypeAlt))) && isStoneTypeBlacklisted) {
                    Optional opt = BuiltInRegistries.f_256975_.m_6612_(idBlockType);
                    Optional alt = BuiltInRegistries.f_256975_.m_6612_(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneName), (Block)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneAlt), (Block)alt.get()));
                    }
                }
            } else if (path.matches("polished_[a-z]+(?:_stone)?") && baseblock.m_49966_().m_280603_() == NoteBlockInstrument.BASEDRUM) {
                boolean isStoneTypeBlacklisted;
                String stoneName = path.replace("polished_", "");
                stoneAlt = stoneName + "_stone";
                idBlockType = baseRes.m_247449_(stoneName);
                ResourceLocation idBlockTypeAlt = baseRes.m_247449_(stoneAlt);
                boolean bl = isStoneTypeBlacklisted = !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneName).toString()) && !HardcodedBlockType.BLACKLISTED_STONETYPES.contains(baseRes.m_247449_(stoneAlt).toString());
                if ((Objects.isNull(this.get(idBlockType)) || Objects.isNull(this.get(idBlockTypeAlt))) && isStoneTypeBlacklisted) {
                    Optional opt = BuiltInRegistries.f_256975_.m_6612_(idBlockType);
                    Optional alt = BuiltInRegistries.f_256975_.m_6612_(idBlockTypeAlt);
                    if (opt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneName), (Block)opt.get()));
                    }
                    if (alt.isPresent()) {
                        return Optional.of(new StoneType(baseRes.m_247449_(stoneAlt), (Block)alt.get()));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(stoneType -> {
            if (language.isDefault()) {
                language.addEntry(stoneType.getTranslationKey(), stoneType.getReadableName());
            }
        });
    }

    public int priority() {
        return 110;
    }
}

