/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class RockType
extends BlockType {
    public final Block block;

    protected RockType(ResourceLocation id, Block stone) {
        super(id);
        this.block = stone;
    }

    public String getAppendableIdWith(String prefix, String suffix) {
        Object suffixed = suffix.isEmpty() ? "" : "_" + suffix;
        Object prefixed = prefix.isEmpty() ? "" : prefix + "_";
        return this.getNamespace() + "/" + (String)prefixed + this.getTypeName() + (String)suffixed;
    }

    protected void initializeChildrenBlocks() {
        this.addChild("stone", this.block);
        this.addChild("stairs", this.findRelatedEntry("stairs", (Registry)BuiltInRegistries.f_256975_));
        this.addChild("slab", this.findRelatedEntry("slab", (Registry)BuiltInRegistries.f_256975_));
        this.addChild("wall", this.findRelatedEntry("wall", (Registry)BuiltInRegistries.f_256975_));
        this.addChild("button", this.findRelatedEntry("button", (Registry)BuiltInRegistries.f_256975_));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", (Registry)BuiltInRegistries.f_256975_));
        this.addChild("smooth_stone", this.findRelatedEntry("smooth", "stone", (Registry)BuiltInRegistries.f_256975_));
        Block cobblestone = (Block)this.findRelatedEntry("cobblestone", (Registry)BuiltInRegistries.f_256975_);
        this.addChild("cobblestone", cobblestone);
        if (Objects.nonNull(cobblestone)) {
            this.addChild("mossy_cobblestone", this.findRelatedEntry("mossy", "cobblestone", (Registry)BuiltInRegistries.f_256975_));
        }
        Block polished = (Block)this.findRelatedEntry("polished", (Registry)BuiltInRegistries.f_256975_);
        this.addChild("polished", polished);
        if (Objects.nonNull(polished)) {
            this.addChild("polished_stairs", this.findRelatedEntry("polished", "stairs", (Registry)BuiltInRegistries.f_256975_));
            this.addChild("polished_slab", this.findRelatedEntry("polished", "slab", (Registry)BuiltInRegistries.f_256975_));
        }
        Block bricks = (Block)this.findRelatedEntry("bricks", (Registry)BuiltInRegistries.f_256975_);
        this.addChild("bricks", bricks);
        if (bricks != null) {
            if (this.id.m_135827_().matches("tfc|afc")) {
                this.addChild("brick_stairs", this.findRelatedEntry("bricks", "stairs", (Registry)BuiltInRegistries.f_256975_));
                this.addChild("brick_slab", this.findRelatedEntry("bricks", "slab", (Registry)BuiltInRegistries.f_256975_));
                this.addChild("brick_wall", this.findRelatedEntry("bricks", "wall", (Registry)BuiltInRegistries.f_256975_));
                this.addChild("cracked_bricks", this.findRelatedEntry("cracked_bricks", (Registry)BuiltInRegistries.f_256975_));
            } else {
                this.addChild("brick_stairs", this.findChildBrickEntry("stairs"));
                this.addChild("brick_slab", this.findChildBrickEntry("slab"));
                this.addChild("brick_wall", this.findChildBrickEntry("wall"));
                this.addChild("brick_tiles", this.findChildBrickEntry("tiles"));
                this.addChild("cracked_bricks", this.findBrickEntry("cracked", ""));
                this.addChild("mossy_bricks", this.findBrickEntry("mossy", ""));
                this.addChild("mossy_brick_slab", this.findBrickEntry("mossy", "slab"));
                this.addChild("mossy_brick_stairs", this.findBrickEntry("mossy", "stairs"));
                this.addChild("mossy_brick_wall", this.findBrickEntry("mossy", "wall"));
            }
        }
        Block smoothTFC = (Block)this.findRelatedEntry("smooth", (Registry)BuiltInRegistries.f_256975_);
        this.addChild("smooth_stone", smoothTFC);
        if (Objects.nonNull(smoothTFC)) {
            this.addChild("smooth_stairs", this.findRelatedEntry("smooth", "stairs", (Registry)BuiltInRegistries.f_256975_));
            this.addChild("smooth_slab", this.findRelatedEntry("smooth", "slab", (Registry)BuiltInRegistries.f_256975_));
            this.addChild("smooth_wall", this.findRelatedEntry("smooth", "wall", (Registry)BuiltInRegistries.f_256975_));
        }
    }

    protected void initializeChildrenItems() {
        this.addChild("brick", this.findRelatedEntry("brick", (Registry)BuiltInRegistries.f_257033_));
    }

    @Nullable
    private Block findChildBrickEntry(String suffix) {
        Block first = (Block)this.findRelatedEntry("brick_" + suffix, (Registry)BuiltInRegistries.f_256975_);
        if (first != null) {
            return first;
        }
        return (Block)this.findRelatedEntry("bricks_" + suffix, (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    private Block findBrickEntry(String pre, String post) {
        Block first = (Block)this.findRelatedEntry(pre, "brick" + (String)(post = ((String)post).isEmpty() ? "" : "_" + (String)post), (Registry)BuiltInRegistries.f_256975_);
        if (first != null) {
            return first;
        }
        return (Block)this.findRelatedEntry(pre, "bricks" + (String)post, (Registry)BuiltInRegistries.f_256975_);
    }

    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, Registry<V> reg) {
        if (this.id.toString().equals("minecraft:stone") && prefixOrInfix.equals("cobblestone")) {
            return (V)reg.m_7745_(new ResourceLocation("cobblestone"));
        }
        if (!((String)suffix).isEmpty()) {
            suffix = "_" + (String)suffix;
        }
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_" + prefixOrInfix + (String)suffix), new ResourceLocation(this.id.m_135827_(), prefixOrInfix + "_" + this.id.m_135815_() + (String)suffix), new ResourceLocation(this.id.m_135827_(), "rock/raw/" + this.id.m_135815_() + "_" + prefixOrInfix), new ResourceLocation(this.id.m_135827_(), "rock/" + prefixOrInfix + (String)suffix + "/" + this.id.m_135815_()), new ResourceLocation(this.id.m_135827_(), "rock/" + prefixOrInfix + "/" + this.id.m_135815_() + (String)suffix)};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    protected <V> V findRelatedEntry(String prefixOrInfix, Registry<V> reg) {
        return this.findRelatedEntry(prefixOrInfix, "", reg);
    }

    public ItemLike mainChild() {
        return this.block;
    }

    public Block bricksOrStone() {
        Block bricks = this.getBlockOfThis("bricks");
        return bricks != null ? bricks : this.block;
    }
}

