/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.stone_zone.api.set.MudType;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class MudTypeRegistry
extends BlockTypeRegistry<MudType> {
    public static final MudTypeRegistry INSTANCE = new MudTypeRegistry();

    public MudTypeRegistry() {
        super(MudType.class, "mud_type");
        this.addFinder(MudType.Finder.vanilla("mud"));
    }

    public static MudType getMudType() {
        return MudTypeRegistry.getValue("mud");
    }

    public static Collection<MudType> getTypes() {
        return INSTANCE.getValues();
    }

    public static MudType getValue(String mudTypeId) {
        return (MudType)INSTANCE.get(new ResourceLocation(mudTypeId));
    }

    public MudType getDefaultType() {
        return MudTypeRegistry.getMudType();
    }

    public Optional<MudType> detectTypeFromBlock(Block baseblock, ResourceLocation baseRes) {
        String path = baseRes.m_135815_();
        if (path.matches("[a-z]+_mud_bricks") && baseblock.m_49966_().m_280603_() == NoteBlockInstrument.BASEDRUM && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.m_135827_())) {
            String mudName = path.substring(0, path.length() - 7);
            String mudAlt = mudName + "_mud";
            ResourceLocation idBlockType = baseRes.m_247449_(mudName);
            ResourceLocation idBlockTypeAlt = baseRes.m_247449_(mudAlt);
            if (Objects.isNull(this.get(idBlockType)) || Objects.isNull(this.get(idBlockTypeAlt))) {
                Optional opt = BuiltInRegistries.f_256975_.m_6612_(baseRes.m_247449_(mudName));
                Optional alt = BuiltInRegistries.f_256975_.m_6612_(baseRes.m_247449_(mudAlt));
                if (opt.isPresent()) {
                    return Optional.of(new MudType(baseRes.m_247449_(mudName), (Block)opt.get()));
                }
                if (alt.isPresent()) {
                    return Optional.of(new MudType(baseRes.m_247449_(mudAlt), (Block)alt.get()));
                }
            }
        }
        return Optional.empty();
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(mudType -> {
            if (language.isDefault()) {
                language.addEntry(mudType.getTranslationKey(), mudType.getReadableName());
            }
        });
    }

    public int priority() {
        return 110;
    }
}

