/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.stone_zone.SZRegistry;
import net.mehvahdjukaar.stone_zone.api.set.StoneType;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.mehvahdjukaar.stone_zone.misc.ModelUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;

public class StonezoneModule
extends SimpleModule {
    private final Set<ResourceLocation> modelsToModify = new HashSet<ResourceLocation>();

    public StonezoneModule(String modId, String shortId) {
        super(modId, shortId, "stonezone");
    }

    public ResourceKey<CreativeModeTab> getDedicatedTab() {
        return SZRegistry.MOD_TAB.getKey();
    }

    public String toString() {
        return "StoneZone " + LangBuilder.getReadableName((String)this.modId) + " Module";
    }

    public ResourceLocation makeMyRes(String name) {
        return super.makeMyRes(name);
    }

    public boolean isEntryAlreadyRegistered(String blockId, BlockType blockType, Registry<?> registry) {
        StoneType stoneType;
        Boolean hardcoded;
        String blockName = blockId.substring(blockId.lastIndexOf("/") + 1);
        if (blockType instanceof StoneType && (hardcoded = HardcodedBlockType.isStoneBlockAlreadyRegistered(blockName, stoneType = (StoneType)blockType, this.modId, this.shortenedId())) != null) {
            return hardcoded;
        }
        boolean isAlreadyRegistered = super.isEntryAlreadyRegistered(blockId, blockType, registry);
        if (isAlreadyRegistered) {
            return isAlreadyRegistered;
        }
        return false;
    }

    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        Map<ResourceLocation, JsonObject> models = ModelUtils.readAllModelsAndParents(manager, this.modelsToModify);
        for (Map.Entry<ResourceLocation, JsonObject> e : models.entrySet()) {
            JsonObject json = e.getValue();
            ModelUtils.addTintIndexToModelAndReplaceParent(json, null, null);
            ResourceLocation newId = ModelUtils.transformModelID(e.getKey());
            ((DynamicTexturePack)handler.dynamicPack).addJson(newId, (JsonElement)json, ResType.MODELS);
        }
    }

    public void markModelForModification(ResourceLocation oldRes) {
        this.modelsToModify.add(oldRes);
    }
}

