/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.mehvahdjukaar.stone_zone.misc.ModelUtils;
import net.mehvahdjukaar.stone_zone.misc.SpriteHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StonezoneEntrySet<T extends BlockType, B extends Block>
extends SimpleEntrySet<T, B> {
    protected StonezoneEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<B> baseBlock, Supplier<T> baseType, @NotNull Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, SimpleEntrySet.LootTableMode lootMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable SimpleEntrySet.ITileHolder tileFactory, @Nullable Object renderType, @Nullable @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition) {
        super(type, name, prefix, blockSupplier, baseBlock, baseType, tab, tabMode, lootMode, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform, mergedPalette, copyTint, condition);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, ResourceManager manager) {
        String nameBaseStone = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager).replaceWithTextureFromChild("minecraft:block/" + nameBaseStone, "stone").replaceWithTextureFromChild("minecraft:block/cobblestone", "cobblestone").replaceWithTextureFromChild("minecraft:block/" + nameBaseStone + "_bricks", "bricks").replaceWithTextureFromChild("minecraft:block/smooth_" + nameBaseStone, "smooth_stone").replaceWithTextureFromChild("minecraft:block/polished_" + nameBaseStone, "polished").replaceWithTextureFromChild("minecraft:block/mossy_" + nameBaseStone + "_bricks", "mossy_bricks").addModifier((s, blockId, blockType) -> {
            if (!blockId.m_135815_().contains("chest")) {
                JsonObject jsonObject = GsonHelper.m_13864_((String)s);
                ModelUtils.addTintIndexToModelAndReplaceParent(jsonObject, module, nameBaseStone);
                return jsonObject.toString();
            }
            return s;
        }).andThen(super.makeModelTransformer(module, manager));
    }

    protected BlockTypeResTransformer<T> makeBlockStateTransformer(SimpleModule module, ResourceManager manager) {
        String nameBaseStone = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + nameBaseStone, this.getChildModelId("stone", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + nameBaseStone + "_bricks", this.getChildModelId("bricks", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/smooth_" + nameBaseStone, this.getChildModelId("smooth_stone", stoneType, blockId))).andThen(super.makeBlockStateTransformer(module, manager));
    }

    private String getChildModelId(String childkey, T stoneType, ResourceLocation blockId) {
        if (SpriteHelper.modelID.containsKey(blockId)) {
            return SpriteHelper.modelID.get(blockId);
        }
        return Utils.getID((Block)stoneType.getBlockOfThis(childkey)).m_246208_("block/").toString();
    }

    public void generateTags(SimpleModule module, DynamicDataPack pack, ResourceManager manager) {
        super.generateTags(module, pack, manager);
        this.addTagToAllBlocks("wardstone", "architects_palette", "wizard_blocks", true, false, pack);
        this.addTagToAllBlocks("seared_stone", "tconstruct", "seared_blocks", true, true, pack);
        this.addTagToAllBlocks("scorched_stone", "tconstruct", "scorched_blocks", true, true, pack);
        this.addTagToAllBlocks("sugilite", "caverns_and_chasms", "static_note_blocks", true, true, pack);
        this.addTagToAllBlocks("cassiterite", "caverns_and_chasms", "deflects_projectiles", true, false, pack);
        this.addTagToAllBlocks("cassiterite", "caverns_and_chasms", "weaker_deflect_velocity", true, false, pack);
    }

    public void addTagToAllBlocks(String nameStone, String modId, String tag, boolean includeBlock, boolean includeItem, DynamicDataPack pack) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)new ResourceLocation(modId, tag));
            for (Map.Entry e : this.blocks.entrySet()) {
                BlockType stoneType = (BlockType)e.getKey();
                Block block = (Block)e.getValue();
                if (!stoneType.getTypeName().equals(nameStone)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, Registries.f_256747_);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, Registries.f_256913_);
                }
            }
        }
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends SimpleEntrySet.Builder<T, B> {
        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType, baseBlock, blockFactory);
        }

        public Builder<T, B> createPaletteFromStone() {
            return (Builder)this.createPaletteFromChild("stone");
        }

        public Builder<T, B> createPaletteFromBricks() {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild("bricks") != null) {
                    return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"bricks", null, (BlockType)blockType, (ResourceManager)manager);
                }
                return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"stone", null, (BlockType)blockType, (ResourceManager)manager);
            });
            return this;
        }

        public Builder<T, B> createPaletteFromStoneChild(String childKey) {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild(childKey) != null) {
                    return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)childKey, null, (BlockType)blockType, (ResourceManager)manager);
                }
                return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"stone", null, (BlockType)blockType, (ResourceManager)manager);
            });
            return this;
        }

        public StonezoneEntrySet<T, B> build() {
            if (this.tab == null && PlatHelper.isDev()) {
                throw new IllegalStateException("Tab for module " + this.name + " was null!");
            }
            this.copyParentTint();
            StonezoneEntrySet e = new StonezoneEntrySet(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.tabMode, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.useMergedPalette, this.copyTint, this.condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }
    }
}

